/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferLockImpl
implements StateTransferLock {
    private static final Log log = LogFactory.getLog(StateTransferLockImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ReadWriteLock ownershipLock = new ReentrantReadWriteLock();
    private volatile int topologyId;
    private final Object topologyLock = new Object();
    private volatile int transactionDataTopologyId;
    private final Object transactionDataLock = new Object();

    @Override
    public void acquireExclusiveTopologyLock() {
        this.ownershipLock.writeLock().lock();
    }

    @Override
    public void releaseExclusiveTopologyLock() {
        this.ownershipLock.writeLock().unlock();
    }

    @Override
    public void acquireSharedTopologyLock() {
        this.ownershipLock.readLock().lock();
    }

    @Override
    public void releaseSharedTopologyLock() {
        this.ownershipLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTransactionDataReceived(int topologyId) {
        if (topologyId < this.transactionDataTopologyId) {
            throw new IllegalStateException("Cannot set a topology id (" + topologyId + ") that is lower than the current one (" + this.transactionDataTopologyId + ")");
        }
        if (trace) {
            log.tracef("Signalling transaction data received for topology %d", topologyId);
        }
        this.transactionDataTopologyId = topologyId;
        Object object = this.transactionDataLock;
        synchronized (object) {
            this.transactionDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForTransactionData(int expectedTopologyId) throws InterruptedException {
        if (this.transactionDataTopologyId >= expectedTopologyId) {
            return;
        }
        if (trace) {
            log.tracef("Waiting for transaction data for topology %d, current topology is %d", expectedTopologyId, this.transactionDataTopologyId);
        }
        Object object = this.transactionDataLock;
        synchronized (object) {
            while (this.transactionDataTopologyId < expectedTopologyId) {
                this.transactionDataLock.wait();
            }
        }
        if (trace) {
            log.tracef("Received transaction data for topology %d, expected topology was %d", this.transactionDataTopologyId, expectedTopologyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTopologyInstalled(int topologyId) {
        if (topologyId < this.topologyId) {
            throw new IllegalStateException("Cannot set a topology id (" + topologyId + ") that is lower than the current one (" + this.topologyId + ")");
        }
        if (trace) {
            log.tracef("Signalling topology %d is installed", topologyId);
        }
        this.topologyId = topologyId;
        Object object = this.topologyLock;
        synchronized (object) {
            this.topologyLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForTopology(int expectedTopologyId) throws InterruptedException {
        if (this.topologyId >= expectedTopologyId) {
            return;
        }
        if (trace) {
            log.tracef("Waiting for topology %d to be installed, current topology is %d", expectedTopologyId, this.topologyId);
        }
        Object object = this.topologyLock;
        synchronized (object) {
            while (this.topologyId < expectedTopologyId) {
                this.topologyLock.wait();
            }
        }
        if (trace) {
            log.tracef("Topology %d is now installed, expected topology was %d", this.topologyId, expectedTopologyId);
        }
    }
}

