/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.jdbc.accessors;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DynamicDataSourceJDBCAccess
implements JDBCAccess {
    private DataSource dataSource;

    @Override
    public Connection getConnection() throws SQLException, NamingException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public void initialise(StringTokenizer tokenizer) {
        while (tokenizer.hasMoreElements()) {
            HashMap<String, String> configuration = new HashMap<String, String>();
            while (tokenizer.hasMoreTokens()) {
                String[] split = tokenizer.nextToken().split("=");
                configuration.put(split[0], split[1]);
            }
            try {
                this.dataSource = (DataSource)Class.forName((String)configuration.remove("ClassName")).newInstance();
                for (String key : configuration.keySet()) {
                    String value = (String)configuration.get(key);
                    Method method = null;
                    try {
                        method = this.dataSource.getClass().getMethod("set" + key, String.class);
                        method.invoke((Object)this.dataSource, value);
                    }
                    catch (NoSuchMethodException nsme) {
                        method = this.dataSource.getClass().getMethod("set" + key, Integer.TYPE);
                        method.invoke((Object)this.dataSource, Integer.valueOf(value));
                    }
                }
            }
            catch (Exception ex) {
                this.dataSource = null;
                throw new FatalError(this.toString() + " : " + ex, ex);
            }
        }
    }
}

