/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.felix.cm.impl.ConfigurationAdminImpl;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.osgi.service.cm.Configuration;

public class ConfigurationAdapter
implements Configuration {
    private final ConfigurationAdminImpl configurationAdmin;
    private final ConfigurationImpl delegatee;

    ConfigurationAdapter(ConfigurationAdminImpl configurationAdmin, ConfigurationImpl delegatee) {
        this.configurationAdmin = configurationAdmin;
        this.delegatee = delegatee;
    }

    @Override
    public String getPid() {
        this.checkDeleted();
        return this.delegatee.getPid();
    }

    @Override
    public String getFactoryPid() {
        this.checkDeleted();
        return this.delegatee.getFactoryPid();
    }

    @Override
    public String getBundleLocation() {
        this.configurationAdmin.checkPermission();
        this.checkDeleted();
        return this.delegatee.getBundleLocation();
    }

    @Override
    public void setBundleLocation(String bundleLocation) {
        this.configurationAdmin.checkPermission();
        this.checkDeleted();
        this.delegatee.setStaticBundleLocation(bundleLocation);
    }

    @Override
    public void update() throws IOException {
        this.checkDeleted();
        this.delegatee.update();
    }

    @Override
    public void update(Dictionary properties) throws IOException {
        this.checkDeleted();
        this.delegatee.update(properties);
    }

    @Override
    public Dictionary getProperties() {
        this.checkDeleted();
        return this.delegatee.getProperties(true);
    }

    @Override
    public void delete() throws IOException {
        this.checkDeleted();
        this.delegatee.delete();
    }

    @Override
    public int hashCode() {
        return this.delegatee.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegatee.equals(obj);
    }

    public String toString() {
        return this.delegatee.toString();
    }

    private void checkDeleted() {
        if (this.delegatee.isDeleted()) {
            throw new IllegalStateException("Configuration " + this.delegatee.getPid() + " deleted");
        }
    }
}

