/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.LinkedList;
import org.apache.felix.cm.impl.ConfigurationManager;

public class UpdateThread
implements Runnable {
    private final ConfigurationManager configurationManager;
    private final String workerBaseName;
    private final LinkedList updateTasks;
    private final Thread worker;

    public UpdateThread(ConfigurationManager configurationManager, ThreadGroup tg, String name) {
        this.configurationManager = configurationManager;
        this.workerBaseName = name;
        this.updateTasks = new LinkedList();
        this.worker = new Thread(tg, this, name);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Runnable task;
            LinkedList linkedList = this.updateTasks;
            synchronized (linkedList) {
                while (this.updateTasks.isEmpty()) {
                    try {
                        this.updateTasks.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                task = (Runnable)this.updateTasks.removeFirst();
            }
            if (task == this) {
                return;
            }
            try {
                this.worker.setName(this.workerBaseName + " (" + task + ")");
                if (this.configurationManager.isLogEnabled(4)) {
                    this.configurationManager.log(4, "Running task " + task, null);
                }
                task.run();
                continue;
            }
            catch (Throwable t) {
                this.configurationManager.log(1, "Unexpected problem executing task", t);
                continue;
            }
            finally {
                this.worker.setName(this.workerBaseName);
                continue;
            }
            break;
        }
    }

    void terminate() {
        this.schedule(this);
        try {
            this.worker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable update) {
        LinkedList linkedList = this.updateTasks;
        synchronized (linkedList) {
            if (this.configurationManager.isLogEnabled(4)) {
                this.configurationManager.log(4, "Scheduling task " + update, null);
            }
            this.updateTasks.add(update);
            this.updateTasks.notifyAll();
        }
    }
}

