/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.JDKPaths;
import org.jboss.osgi.framework.spi.FrameworkBuilder;
import org.jboss.osgi.framework.spi.SystemPaths;

public final class SystemPathsImpl
implements SystemPaths {
    private final FrameworkBuilder frameworkBuilder;
    private Set<String> systemPackages = new LinkedHashSet<String>();
    private Set<String> bootDelegationPackages = new LinkedHashSet<String>();
    private Set<String> frameworkPackages = new LinkedHashSet<String>();
    private Set<String> cachedBootDelegationPaths;
    private PathFilter cachedBootDelegationFilter;
    private Set<String> cachedFrameworkPaths;
    private PathFilter cachedFrameworkFilter;
    private Set<String> cachedSystemPaths;
    private PathFilter cachedSystemFilter;

    public SystemPathsImpl(FrameworkBuilder frameworkBuilder) {
        String bootDelegationProp;
        this.frameworkBuilder = frameworkBuilder;
        this.frameworkPackages.addAll(Arrays.asList(SystemPaths.DEFAULT_FRAMEWORK_PACKAGES));
        String systemPackagesProp = (String)frameworkBuilder.getProperty("org.osgi.framework.system.packages");
        if (systemPackagesProp != null) {
            this.systemPackages.addAll(this.packagesAsList(systemPackagesProp));
        } else {
            this.systemPackages.addAll(Arrays.asList(SystemPaths.DEFAULT_SYSTEM_PACKAGES));
            this.systemPackages.addAll(this.frameworkPackages);
        }
        String extraPackages = (String)frameworkBuilder.getProperty("org.osgi.framework.system.packages.extra");
        if (extraPackages != null) {
            this.systemPackages.addAll(this.packagesAsList(extraPackages));
        }
        if ((bootDelegationProp = (String)frameworkBuilder.getProperty("org.osgi.framework.bootdelegation")) != null) {
            String[] packageNames;
            for (String packageName : packageNames = bootDelegationProp.split(",")) {
                this.bootDelegationPackages.add(packageName);
            }
        } else {
            this.bootDelegationPackages.add("sun.*");
            this.bootDelegationPackages.add("com.sun.*");
        }
    }

    @Override
    public Set<String> getBootDelegationPackages() {
        this.assertInitialized();
        return Collections.unmodifiableSet(this.bootDelegationPackages);
    }

    @Override
    public PathFilter getBootDelegationFilter() {
        this.assertInitialized();
        if (this.cachedBootDelegationFilter == null) {
            MultiplePathFilterBuilder builder = PathFilters.multiplePathFilterBuilder((boolean)false);
            for (String packageName : this.getBootDelegationPackages()) {
                if (packageName.equals("*")) {
                    if (this.doFrameworkPackageDelegation()) {
                        builder.addFilter(PathFilters.acceptAll(), true);
                        continue;
                    }
                    builder.addFilter(PathFilters.all((PathFilter[])new PathFilter[]{PathFilters.acceptAll(), PathFilters.not((PathFilter)this.getFrameworkFilter())}), true);
                    continue;
                }
                if (packageName.endsWith(".*")) {
                    packageName = packageName.substring(0, packageName.length() - 2);
                    builder.addFilter(PathFilters.isChildOf((String)packageName.replace('.', '/')), true);
                    continue;
                }
                builder.addFilter(PathFilters.is((String)packageName.replace('.', '/')), true);
            }
            this.cachedBootDelegationFilter = builder.create();
            FrameworkLogger.LOGGER.tracef("BootDelegationFilter: %s", this.cachedBootDelegationFilter);
        }
        return this.cachedBootDelegationFilter;
    }

    @Override
    public Set<String> getBootDelegationPaths() {
        this.assertInitialized();
        if (this.cachedBootDelegationPaths == null) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            boolean hasBootDelegationWildcards = false;
            for (String packageName : this.getBootDelegationPackages()) {
                if (!packageName.endsWith("*")) continue;
                hasBootDelegationWildcards = true;
                break;
            }
            if (hasBootDelegationWildcards) {
                PathFilter bootDelegationFilter = this.getBootDelegationFilter();
                for (String path : JDKPaths.JDK) {
                    if (!bootDelegationFilter.accept(path)) continue;
                    result.add(path);
                }
            } else {
                for (String packageName : this.getBootDelegationPackages()) {
                    result.add(packageName.replace('.', '/'));
                }
            }
            this.cachedBootDelegationPaths = Collections.unmodifiableSet(result);
            FrameworkLogger.LOGGER.tracef("BootDelegationPaths: %s", this.cachedBootDelegationPaths);
        }
        return this.cachedBootDelegationPaths;
    }

    @Override
    public Set<String> getSystemPackages() {
        this.assertInitialized();
        return Collections.unmodifiableSet(this.systemPackages);
    }

    @Override
    public PathFilter getSystemFilter() {
        this.assertInitialized();
        if (this.cachedSystemFilter == null) {
            MultiplePathFilterBuilder builder = PathFilters.multiplePathFilterBuilder((boolean)false);
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            for (String packageSpec : this.getSystemPackages()) {
                int index = packageSpec.indexOf(59);
                if (index > 0) {
                    packageSpec = packageSpec.substring(0, index);
                }
                String path = packageSpec.replace('.', '/');
                paths.add(path);
            }
            builder.addFilter(PathFilters.in(paths), true);
            this.cachedSystemFilter = builder.create();
            FrameworkLogger.LOGGER.debugf("SystemFilter: %s", this.cachedSystemFilter);
        }
        return this.cachedSystemFilter;
    }

    @Override
    public Set<String> getSystemPaths() {
        this.assertInitialized();
        if (this.cachedSystemPaths == null) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String packageSpec : this.getSystemPackages()) {
                int index = packageSpec.indexOf(59);
                if (index > 0) {
                    packageSpec = packageSpec.substring(0, index);
                }
                String path = packageSpec.replace('.', '/');
                result.add(path);
            }
            this.cachedSystemPaths = Collections.unmodifiableSet(result);
            FrameworkLogger.LOGGER.debugf("SystemPaths: %s", this.cachedSystemPaths);
        }
        return this.cachedSystemPaths;
    }

    private Set<String> getFrameworkPackages() {
        return Collections.unmodifiableSet(this.frameworkPackages);
    }

    private Set<String> getFrameworkPaths() {
        if (this.cachedFrameworkPaths == null) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            for (String packageSpec : this.getFrameworkPackages()) {
                int index = packageSpec.indexOf(59);
                if (index > 0) {
                    packageSpec = packageSpec.substring(0, index);
                }
                paths.add(packageSpec.replace('.', '/'));
            }
            this.cachedFrameworkPaths = Collections.unmodifiableSet(paths);
            FrameworkLogger.LOGGER.debugf("FrameworkPaths: %s", this.cachedFrameworkPaths);
        }
        return this.cachedFrameworkPaths;
    }

    private PathFilter getFrameworkFilter() {
        this.assertInitialized();
        if (this.cachedFrameworkFilter == null) {
            this.cachedFrameworkFilter = PathFilters.in(this.getFrameworkPaths());
            FrameworkLogger.LOGGER.debugf("FrameworkFilter: %s", this.cachedFrameworkFilter);
        }
        return this.cachedFrameworkFilter;
    }

    private boolean doFrameworkPackageDelegation() {
        boolean allBootDelegation;
        String property = (String)this.frameworkBuilder.getProperty("org.osgi.framework.bundle.parent");
        if (property == null) {
            property = "boot";
        }
        return !(allBootDelegation = this.getBootDelegationPackages().contains("*")) || !"boot".equals(property) && !"ext".equals(property);
    }

    private List<String> packagesAsList(String sysPackages) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : sysPackages.split(",")) {
            if ((name = name.trim()).length() <= 0) continue;
            result.add(name);
        }
        return result;
    }

    private void assertInitialized() {
        if (this.systemPackages.isEmpty()) {
            throw FrameworkMessages.MESSAGES.illegalStateSystemPathsNotInitialized();
        }
    }
}

