/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public abstract class AbstractHierarchicalFileConfiguration
extends HierarchicalConfiguration
implements FileConfiguration,
ConfigurationListener {
    private FileConfigurationDelegate delegate;

    protected AbstractHierarchicalFileConfiguration() {
        this.initialize();
    }

    protected AbstractHierarchicalFileConfiguration(HierarchicalConfiguration c) {
        super(c);
        this.initialize();
    }

    public AbstractHierarchicalFileConfiguration(String fileName) throws ConfigurationException {
        this();
        this.delegate.setFileName(fileName);
        this.load();
    }

    public AbstractHierarchicalFileConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public AbstractHierarchicalFileConfiguration(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
        this.load();
    }

    private void initialize() {
        this.delegate = this.createDelegate();
        this.initDelegate(this.delegate);
    }

    @Override
    protected void addPropertyDirect(String key, Object obj) {
        super.addPropertyDirect(key, obj);
        this.delegate.possiblySave();
    }

    @Override
    public void clearProperty(String key) {
        super.clearProperty(key);
        this.delegate.possiblySave();
    }

    @Override
    public void clearTree(String key) {
        super.clearTree(key);
        this.delegate.possiblySave();
    }

    @Override
    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
        this.delegate.possiblySave();
    }

    @Override
    public void load() throws ConfigurationException {
        this.delegate.load();
    }

    @Override
    public void load(String fileName) throws ConfigurationException {
        this.delegate.load(fileName);
    }

    @Override
    public void load(File file) throws ConfigurationException {
        this.delegate.load(file);
    }

    @Override
    public void load(URL url) throws ConfigurationException {
        this.delegate.load(url);
    }

    @Override
    public void load(InputStream in) throws ConfigurationException {
        this.delegate.load(in);
    }

    @Override
    public void load(InputStream in, String encoding) throws ConfigurationException {
        this.delegate.load(in, encoding);
    }

    @Override
    public void save() throws ConfigurationException {
        this.delegate.save();
    }

    @Override
    public void save(String fileName) throws ConfigurationException {
        this.delegate.save(fileName);
    }

    @Override
    public void save(File file) throws ConfigurationException {
        this.delegate.save(file);
    }

    @Override
    public void save(URL url) throws ConfigurationException {
        this.delegate.save(url);
    }

    @Override
    public void save(OutputStream out) throws ConfigurationException {
        this.delegate.save(out);
    }

    @Override
    public void save(OutputStream out, String encoding) throws ConfigurationException {
        this.delegate.save(out, encoding);
    }

    @Override
    public String getFileName() {
        return this.delegate.getFileName();
    }

    @Override
    public void setFileName(String fileName) {
        this.delegate.setFileName(fileName);
    }

    @Override
    public String getBasePath() {
        return this.delegate.getBasePath();
    }

    @Override
    public void setBasePath(String basePath) {
        this.delegate.setBasePath(basePath);
    }

    @Override
    public File getFile() {
        return this.delegate.getFile();
    }

    @Override
    public void setFile(File file) {
        this.delegate.setFile(file);
    }

    @Override
    public URL getURL() {
        return this.delegate.getURL();
    }

    @Override
    public void setURL(URL url) {
        this.delegate.setURL(url);
    }

    @Override
    public void setAutoSave(boolean autoSave) {
        this.delegate.setAutoSave(autoSave);
    }

    @Override
    public boolean isAutoSave() {
        return this.delegate.isAutoSave();
    }

    @Override
    public ReloadingStrategy getReloadingStrategy() {
        return this.delegate.getReloadingStrategy();
    }

    @Override
    public void setReloadingStrategy(ReloadingStrategy strategy) {
        this.delegate.setReloadingStrategy(strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        this.setDetailEvents(false);
        try {
            this.delegate.reload();
        }
        finally {
            this.setDetailEvents(true);
        }
    }

    @Override
    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    @Override
    public void setEncoding(String encoding) {
        this.delegate.setEncoding(encoding);
    }

    @Override
    public boolean containsKey(String key) {
        this.reload();
        return super.containsKey(key);
    }

    @Override
    public Iterator getKeys() {
        this.reload();
        return super.getKeys();
    }

    @Override
    public Iterator getKeys(String prefix) {
        this.reload();
        return super.getKeys(prefix);
    }

    @Override
    public Object getProperty(String key) {
        this.reload();
        return super.getProperty(key);
    }

    @Override
    public boolean isEmpty() {
        this.reload();
        return super.isEmpty();
    }

    @Override
    public void addNodes(String key, Collection nodes) {
        super.addNodes(key, nodes);
        this.delegate.possiblySave();
    }

    @Override
    protected List fetchNodeList(String key) {
        this.reload();
        return super.fetchNodeList(key);
    }

    @Override
    protected void subnodeConfigurationChanged(ConfigurationEvent event) {
        this.delegate.possiblySave();
        super.subnodeConfigurationChanged(event);
    }

    protected FileConfigurationDelegate createDelegate() {
        return new FileConfigurationDelegate();
    }

    private void initDelegate(FileConfigurationDelegate del) {
        del.addConfigurationListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationChanged(ConfigurationEvent event) {
        this.setDetailEvents(true);
        try {
            this.fireEvent(event.getType(), event.getPropertyName(), event.getPropertyValue(), event.isBeforeUpdate());
        }
        finally {
            this.setDetailEvents(false);
        }
    }

    protected FileConfigurationDelegate getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(FileConfigurationDelegate delegate) {
        this.delegate = delegate;
    }

    protected class FileConfigurationDelegate
    extends AbstractFileConfiguration {
        protected FileConfigurationDelegate() {
        }

        @Override
        public void load(Reader in) throws ConfigurationException {
            AbstractHierarchicalFileConfiguration.this.load(in);
        }

        @Override
        public void save(Writer out) throws ConfigurationException {
            AbstractHierarchicalFileConfiguration.this.save(out);
        }

        @Override
        public void clear() {
            AbstractHierarchicalFileConfiguration.this.clear();
        }
    }
}

