/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ClassLoaderSearchUtil;
import org.jboss.shrinkwrap.api.SecurityActions;
import org.jboss.shrinkwrap.api.ShrinkWrap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchivePaths {
    private static final String PATH_IMPL = "org.jboss.shrinkwrap.impl.base.path.BasicPath";

    public static ArchivePath root() {
        return RootPathWrapper.INSTANCE.getRoot();
    }

    public static ArchivePath create(String context) {
        return ArchivePaths.createInstance(new Class[]{String.class}, new Object[]{context});
    }

    public static ArchivePath create(String basePath, String context) {
        return ArchivePaths.createInstance(new Class[]{String.class, String.class}, new Object[]{basePath, context});
    }

    public static ArchivePath create(String basePath, ArchivePath context) {
        return ArchivePaths.createInstance(new Class[]{String.class, ArchivePath.class}, new Object[]{basePath, context});
    }

    public static ArchivePath create(ArchivePath basePath, String context) {
        return ArchivePaths.createInstance(new Class[]{ArchivePath.class, String.class}, new Object[]{basePath, context});
    }

    public static ArchivePath create(ArchivePath basePath, ArchivePath context) {
        return ArchivePaths.createInstance(new Class[]{ArchivePath.class, ArchivePath.class}, new Object[]{basePath, context});
    }

    private static ArchivePath createInstance(Class<?>[] argumentTypes, Object[] arguments) {
        Class<?> archivePathImplClass;
        try {
            archivePathImplClass = ClassLoaderSearchUtil.findClassFromClassLoaders(PATH_IMPL, ShrinkWrap.getDefaultDomain().getConfiguration().getClassLoaders());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Could not find the archive path implementation class org.jboss.shrinkwrap.impl.base.path.BasicPath in any configured ClassLoader", cnfe);
        }
        return SecurityActions.newInstance(archivePathImplClass, argumentTypes, arguments, ArchivePath.class);
    }

    private ArchivePaths() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RootPathWrapper {
        INSTANCE;

        private ArchivePath root = ArchivePaths.create(null);

        private ArchivePath getRoot() {
            return this.root;
        }
    }
}

