/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.net.SPNEGOServerSocket;

public class SPNEGOServerSocketFactory
extends ServerSocketFactory {
    private String securityDomain = "other";
    private String hostSecurityDomain = "host";
    private static Logger log = Logger.getLogger(SPNEGOServerSocketFactory.class);

    public SPNEGOServerSocketFactory() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating " + this.getClass().getName()));
        }
    }

    public SPNEGOServerSocketFactory(String securityDomain, String hostSecurityDomain) {
        this();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting security domain: " + securityDomain + ". Setting host security domain: " + hostSecurityDomain));
        }
        this.securityDomain = securityDomain;
        this.hostSecurityDomain = hostSecurityDomain;
    }

    public static ServerSocketFactory getDefault() {
        return new SPNEGOServerSocketFactory();
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        SPNEGOServerSocket socket = new SPNEGOServerSocket();
        socket.setSecurityDomain(this.securityDomain);
        socket.setHostSecurityDomain(this.hostSecurityDomain);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SPNEGOServerSocket socket = new SPNEGOServerSocket(port);
        socket.setSecurityDomain(this.securityDomain);
        socket.setHostSecurityDomain(this.hostSecurityDomain);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SPNEGOServerSocket socket = new SPNEGOServerSocket(port, backlog);
        socket.setSecurityDomain(this.securityDomain);
        socket.setHostSecurityDomain(this.hostSecurityDomain);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SPNEGOServerSocket socket = new SPNEGOServerSocket(port, backlog, ifAddress);
        socket.setSecurityDomain(this.securityDomain);
        socket.setHostSecurityDomain(this.hostSecurityDomain);
        return socket;
    }
}

