/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.osgi.repository.AttributeValueHandler;
import org.jboss.osgi.repository.Namespace100;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryReader;
import org.jboss.osgi.repository.URLResourceBuilderFactory;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class RepositoryXMLReader
implements RepositoryReader {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final XMLStreamReader reader;

    public static RepositoryReader create(InputStream input) {
        return new RepositoryXMLReader(input);
    }

    private RepositoryXMLReader(InputStream input) {
        try {
            this.reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
        }
        catch (Exception ex) {
            throw RepositoryMessages.MESSAGES.illegalStateCannotInitializeRepositoryReader(ex);
        }
        try {
            this.reader.require(7, null, null);
            this.reader.nextTag();
            this.reader.require(1, "http://www.osgi.org/xmlns/repository/v1.0.0", Namespace100.Element.REPOSITORY.getLocalName());
            for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                this.attributes.put(this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
            }
        }
        catch (Exception ex) {
            throw RepositoryMessages.MESSAGES.storageCannotReadResourceElement(ex, this.reader.getLocation());
        }
    }

    @Override
    public Map<String, String> getRepositoryAttributes() {
        return this.attributes;
    }

    @Override
    public XResource nextResource() {
        try {
            while (this.reader.hasNext() && this.reader.nextTag() != 2) {
                Namespace100.Element element = Namespace100.Element.forName(this.reader.getLocalName());
                switch (element) {
                    case RESOURCE: {
                        return this.readResourceElement(this.reader);
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw RepositoryMessages.MESSAGES.storageCannotReadResourceElement(ex, this.reader.getLocation());
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private XResource readResourceElement(XMLStreamReader reader) throws XMLStreamException {
        XCapability ccap;
        String urlspec;
        XResourceBuilder builder = XResourceBuilderFactory.create();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace100.Element element = Namespace100.Element.forName(reader.getLocalName());
            switch (element) {
                case CAPABILITY: {
                    this.readCapabilityElement(reader, builder);
                    break;
                }
                case REQUIREMENT: {
                    this.readRequirementElement(reader, builder);
                }
            }
        }
        XResource resource = builder.getResource();
        List caps = resource.getCapabilities("osgi.content");
        if (caps.size() > 0 && (urlspec = (String)(ccap = (XCapability)caps.get(0)).getAttribute("url")) != null) {
            URL contentURL;
            try {
                contentURL = new URL(urlspec);
            }
            catch (MalformedURLException ex) {
                throw RepositoryMessages.MESSAGES.storageInvalidContentURL(urlspec);
            }
            builder = URLResourceBuilderFactory.create(contentURL, ccap.getAttributes(), false);
            for (Capability cap : resource.getCapabilities(null)) {
                if (cap == ccap) continue;
                builder.addCapability(cap.getNamespace(), cap.getAttributes(), cap.getDirectives());
            }
            for (Requirement req : resource.getRequirements(null)) {
                String namespace = req.getNamespace();
                builder.addRequirement(namespace, req.getAttributes(), req.getDirectives());
            }
            resource = builder.getResource();
        }
        return resource;
    }

    private void readCapabilityElement(XMLStreamReader reader, XResourceBuilder builder) throws XMLStreamException {
        String namespace = reader.getAttributeValue(null, Namespace100.Attribute.NAMESPACE.toString());
        HashMap<String, Object> atts = new HashMap<String, Object>();
        HashMap<String, String> dirs = new HashMap<String, String>();
        this.readAttributesAndDirectives(reader, atts, dirs);
        try {
            builder.addCapability(namespace, atts, dirs);
        }
        catch (RuntimeException ex) {
            throw RepositoryMessages.MESSAGES.storageCannotReadResourceElement(ex, reader.getLocation());
        }
    }

    private void readRequirementElement(XMLStreamReader reader, XResourceBuilder builder) throws XMLStreamException {
        String namespace = reader.getAttributeValue(null, Namespace100.Attribute.NAMESPACE.toString());
        HashMap<String, Object> atts = new HashMap<String, Object>();
        HashMap<String, String> dirs = new HashMap<String, String>();
        this.readAttributesAndDirectives(reader, atts, dirs);
        try {
            builder.addRequirement(namespace, atts, dirs);
        }
        catch (RuntimeException ex) {
            throw RepositoryMessages.MESSAGES.storageCannotReadResourceElement(ex, reader.getLocation());
        }
    }

    private void readAttributesAndDirectives(XMLStreamReader reader, Map<String, Object> atts, Map<String, String> dirs) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace100.Element element = Namespace100.Element.forName(reader.getLocalName());
            switch (element) {
                case ATTRIBUTE: {
                    this.readAttributeElement(reader, atts);
                    break;
                }
                case DIRECTIVE: {
                    this.readDirectiveElement(reader, dirs);
                }
            }
        }
    }

    private void readAttributeElement(XMLStreamReader reader, Map<String, Object> attributes) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Namespace100.Attribute.NAME.toString());
        String valstr = reader.getAttributeValue(null, Namespace100.Attribute.VALUE.toString());
        String typespec = reader.getAttributeValue(null, Namespace100.Attribute.TYPE.toString());
        AttributeValueHandler.AttributeValue value = AttributeValueHandler.readAttributeValue(typespec, valstr);
        attributes.put(name, value.getValue());
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
    }

    private void readDirectiveElement(XMLStreamReader reader, Map<String, String> directives) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Namespace100.Attribute.NAME.toString());
        String value = reader.getAttributeValue(null, Namespace100.Attribute.VALUE.toString());
        directives.put(name, value);
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
    }
}

