/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.connector.Connector;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.modcluster.CustomLoadMetricDefinition;
import org.jboss.as.modcluster.DynamicLoadProviderDefinition;
import org.jboss.as.modcluster.LoadMetricDefinition;
import org.jboss.as.modcluster.LoadMetricEnum;
import org.jboss.as.modcluster.ModClusterConfigAdd;
import org.jboss.as.modcluster.ModClusterConfigResourceDefinition;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterSSLResourceDefinition;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.SimpleLoadBalanceFactorProvider;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class ModClusterSubsystemAdd
extends AbstractAddStepHandler {
    private static final OperationContext.AttachmentKey<Boolean> SUBSYSTEM_ADD_KEY = OperationContext.AttachmentKey.create(Boolean.class);
    static final ModClusterSubsystemAdd INSTANCE = new ModClusterSubsystemAdd();

    ModClusterSubsystemAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String bindingRef;
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode modelConfig = fullModel.get(ModClusterExtension.CONFIGURATION_PATH.getKeyValuePair());
        ModClusterConfig config = this.getModClusterConfig(context, modelConfig);
        LoadBalanceFactorProvider loadProvider = this.getModClusterLoadProvider(context, modelConfig);
        String connector = ModClusterConfigResourceDefinition.CONNECTOR.resolveModelAttribute(context, modelConfig).asString();
        ModClusterService service = new ModClusterService(config, loadProvider);
        ServiceBuilder builder = AsynchronousService.addService((ServiceTarget)context.getServiceTarget(), (ServiceName)ModClusterService.NAME, (Service)service, (boolean)true, (boolean)true).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getWebServer()).addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, service.getBindingManager()).addDependency(WebSubsystemServices.JBOSS_WEB_CONNECTOR.append(new String[]{connector}), Connector.class, service.getConnectorInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE);
        ModelNode bindingRefNode = ModClusterConfigResourceDefinition.ADVERTISE_SOCKET.resolveModelAttribute(context, modelConfig);
        String string = bindingRef = bindingRefNode.isDefined() ? bindingRefNode.asString() : null;
        if (bindingRef != null) {
            builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getBinding());
        }
        newControllers.add(builder.install());
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        if (operation.hasDefined("mod-cluster-config")) {
            PathAddress opAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            PathAddress parent = opAddress.append(new PathElement[]{ModClusterExtension.CONFIGURATION_PATH});
            ModelNode targetOperation = Util.createAddOperation((PathAddress)parent);
            for (SimpleAttributeDefinition def : ModClusterConfigResourceDefinition.ATTRIBUTES) {
                def.validateAndSet(operation, targetOperation);
            }
            context.addStep(targetOperation, (OperationStepHandler)ModClusterConfigAdd.INSTANCE, OperationContext.Stage.IMMEDIATE);
        }
        context.attach(SUBSYSTEM_ADD_KEY, (Object)Boolean.TRUE);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    static boolean isActiveInContext(OperationContext context) {
        return context.getAttachment(SUBSYSTEM_ADD_KEY) != null;
    }

    private ModClusterConfig getModClusterConfig(OperationContext context, ModelNode model) throws OperationFailedException {
        ModClusterConfig config = new ModClusterConfig();
        config.setAdvertise(Boolean.valueOf(ModClusterConfigResourceDefinition.ADVERTISE.resolveModelAttribute(context, model).asBoolean()));
        if (model.get(ModClusterExtension.SSL_CONFIGURATION_PATH.getKeyValuePair()).isDefined()) {
            config.setSsl(true);
            ModelNode ssl = model.get(ModClusterExtension.SSL_CONFIGURATION_PATH.getKeyValuePair());
            ModelNode keyAlias = ModClusterSSLResourceDefinition.KEY_ALIAS.resolveModelAttribute(context, ssl);
            ModelNode password = ModClusterSSLResourceDefinition.PASSWORD.resolveModelAttribute(context, ssl);
            if (keyAlias.isDefined()) {
                config.setSslKeyAlias(keyAlias.asString());
            }
            if (password.isDefined()) {
                config.setSslTrustStorePassword(password.asString());
                config.setSslKeyStorePassword(password.asString());
            }
            if (ssl.hasDefined("certificate-key-file")) {
                config.setSslKeyStore(ModClusterSSLResourceDefinition.CERTIFICATE_KEY_FILE.resolveModelAttribute(context, ssl).asString());
            }
            if (ssl.hasDefined("cipher-suite")) {
                config.setSslCiphers(ModClusterSSLResourceDefinition.CIPHER_SUITE.resolveModelAttribute(context, ssl).asString());
            }
            if (ssl.hasDefined("protocol")) {
                config.setSslProtocol(ModClusterSSLResourceDefinition.PROTOCOL.resolveModelAttribute(context, ssl).asString());
            }
            if (ssl.hasDefined("ca-certificate-file")) {
                config.setSslTrustStore(ModClusterSSLResourceDefinition.CA_CERTIFICATE_FILE.resolveModelAttribute(context, ssl).asString());
            }
            if (ssl.hasDefined("ca-revocation-url")) {
                config.setSslCrlFile(ModClusterSSLResourceDefinition.CA_REVOCATION_URL.resolveModelAttribute(context, ssl).asString());
            }
        }
        if (model.hasDefined("proxy-list")) {
            config.setProxyList(ModClusterConfigResourceDefinition.PROXY_LIST.resolveModelAttribute(context, model).asString());
        }
        if (model.hasDefined("advertise-security-key")) {
            config.setAdvertiseSecurityKey(ModClusterConfigResourceDefinition.ADVERTISE_SECURITY_KEY.resolveModelAttribute(context, model).asString());
        }
        config.setProxyURL(ModClusterConfigResourceDefinition.PROXY_URL.resolveModelAttribute(context, model).asString());
        config.setExcludedContexts(ModClusterConfigResourceDefinition.EXCLUDED_CONTEXTS.resolveModelAttribute(context, model).asString().trim());
        config.setAutoEnableContexts(ModClusterConfigResourceDefinition.AUTO_ENABLE_CONTEXTS.resolveModelAttribute(context, model).asBoolean());
        config.setStopContextTimeout(ModClusterConfigResourceDefinition.STOP_CONTEXT_TIMEOUT.resolveModelAttribute(context, model).asInt());
        config.setStopContextTimeoutUnit(TimeUnit.valueOf(ModClusterConfigResourceDefinition.STOP_CONTEXT_TIMEOUT.getMeasurementUnit().getName()));
        config.setSocketTimeout(ModClusterConfigResourceDefinition.SOCKET_TIMEOUT.resolveModelAttribute(context, model).asInt() * 1000);
        config.setStickySession(ModClusterConfigResourceDefinition.STICKY_SESSION.resolveModelAttribute(context, model).asBoolean());
        config.setStickySessionRemove(ModClusterConfigResourceDefinition.STICKY_SESSION_REMOVE.resolveModelAttribute(context, model).asBoolean());
        config.setStickySessionForce(ModClusterConfigResourceDefinition.STICKY_SESSION_FORCE.resolveModelAttribute(context, model).asBoolean());
        config.setWorkerTimeout(ModClusterConfigResourceDefinition.WORKER_TIMEOUT.resolveModelAttribute(context, model).asInt());
        config.setMaxAttempts(ModClusterConfigResourceDefinition.MAX_ATTEMPTS.resolveModelAttribute(context, model).asInt());
        config.setFlushPackets(ModClusterConfigResourceDefinition.FLUSH_PACKETS.resolveModelAttribute(context, model).asBoolean());
        config.setFlushWait(ModClusterConfigResourceDefinition.FLUSH_WAIT.resolveModelAttribute(context, model).asInt());
        config.setPing(ModClusterConfigResourceDefinition.PING.resolveModelAttribute(context, model).asInt());
        config.setSmax(ModClusterConfigResourceDefinition.SMAX.resolveModelAttribute(context, model).asInt());
        config.setTtl(ModClusterConfigResourceDefinition.TTL.resolveModelAttribute(context, model).asInt());
        config.setNodeTimeout(ModClusterConfigResourceDefinition.NODE_TIMEOUT.resolveModelAttribute(context, model).asInt());
        if (model.hasDefined("balancer")) {
            config.setBalancer(ModClusterConfigResourceDefinition.BALANCER.resolveModelAttribute(context, model).asString());
        }
        if (model.hasDefined("load-balancing-group")) {
            config.setLoadBalancingGroup(ModClusterConfigResourceDefinition.LOAD_BALANCING_GROUP.resolveModelAttribute(context, model).asString());
        }
        return config;
    }

    private LoadBalanceFactorProvider getModClusterLoadProvider(OperationContext context, ModelNode model) throws OperationFailedException {
        SimpleLoadBalanceFactorProvider myload;
        SimpleLoadBalanceFactorProvider load = null;
        if (model.hasDefined("simple-load-provider")) {
            int value = ModClusterConfigResourceDefinition.SIMPLE_LOAD_PROVIDER.resolveModelAttribute(context, model).asInt(1);
            myload = new SimpleLoadBalanceFactorProvider();
            myload.setLoadBalanceFactor(value);
            load = myload;
        }
        HashSet<LoadMetric> metrics = new HashSet<LoadMetric>();
        if (model.get(ModClusterExtension.DYNAMIC_LOAD_PROVIDER_PATH.getKeyValuePair()).isDefined()) {
            ModelNode node = model.get(ModClusterExtension.DYNAMIC_LOAD_PROVIDER_PATH.getKeyValuePair());
            int decayFactor = DynamicLoadProviderDefinition.DECAY.resolveModelAttribute(context, model).asInt();
            int history = DynamicLoadProviderDefinition.HISTORY.resolveModelAttribute(context, model).asInt();
            if (node.hasDefined("load-metric")) {
                this.addLoadMetrics(metrics, node.get("load-metric"), context);
            }
            if (node.hasDefined("custom-load-metric")) {
                this.addLoadMetrics(metrics, node.get("custom-load-metric"), context);
            }
            if (!metrics.isEmpty()) {
                DynamicLoadBalanceFactorProvider loader = new DynamicLoadBalanceFactorProvider(metrics);
                loader.setDecayFactor(decayFactor);
                loader.setHistory(history);
                load = loader;
            }
        }
        if (load == null) {
            ModClusterLogger.ROOT_LOGGER.useDefaultLoadBalancer();
            myload = new SimpleLoadBalanceFactorProvider();
            myload.setLoadBalanceFactor(1);
            load = myload;
        }
        return load;
    }

    private void addLoadMetrics(Set<LoadMetric> metrics, ModelNode nodes, OperationContext context) throws OperationFailedException {
        for (Property p : nodes.asPropertyList()) {
            ModelNode node = p.getValue();
            double capacity = LoadMetricDefinition.CAPACITY.resolveModelAttribute(context, node).asDouble();
            int weight = LoadMetricDefinition.WEIGHT.resolveModelAttribute(context, node).asInt();
            Class<? extends LoadMetric> loadMetricClass = null;
            if (node.hasDefined("type")) {
                String type = LoadMetricDefinition.TYPE.resolveModelAttribute(context, node).asString();
                LoadMetricEnum metric = LoadMetricEnum.forType(type);
                loadMetricClass = metric != null ? metric.getLoadMetricClass() : null;
            } else {
                String className = CustomLoadMetricDefinition.CLASS.resolveModelAttribute(context, node).asString();
                try {
                    loadMetricClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className).asSubclass(LoadMetric.class);
                }
                catch (ClassNotFoundException e) {
                    ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
                }
            }
            if (loadMetricClass == null) continue;
            try {
                LoadMetric metric = loadMetricClass.newInstance();
                metric.setCapacity(capacity);
                metric.setWeight(weight);
                metrics.add(metric);
            }
            catch (InstantiationException e) {
                ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
            }
            catch (IllegalAccessException e) {
                ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
            }
        }
    }
}

