/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.util.Iterator;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.HeaderSource;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.jaxrpc.ParameterWrapping;
import org.jboss.ws.core.soap.SOAPBodyElementDoc;
import org.jboss.ws.core.soap.SOAPBodyElementRpc;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.core.soap.SOAPHeaderElementImpl;
import org.jboss.ws.core.soap.attachment.AttachmentPartImpl;
import org.jboss.ws.core.soap.utils.CIDGenerator;
import org.jboss.ws.core.soap.utils.MessageContextAssociation;
import org.jboss.ws.core.soap.utils.SOAPUtils;
import org.jboss.ws.core.soap.utils.Style;
import org.jboss.ws.core.soap.utils.Use;
import org.jboss.ws.core.utils.MimeUtils;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;

public abstract class CommonSOAPBinding
implements CommonBinding {
    protected Logger log = Logger.getLogger(this.getClass());
    protected HeaderSource headerSource;
    public static final String SOAP11HTTP_BINDING = "http://schemas.xmlsoap.org/wsdl/soap/http";
    public static final String SOAP12HTTP_BINDING = "http://www.w3.org/2003/05/soap/bindings/HTTP/";

    public MessageFactory getMessageFactory() {
        return SOAPUtils.newSOAP11MessageFactory();
    }

    public SOAPFactory getSOAPFactory() {
        return SOAPUtils.newSOAP11Factory();
    }

    protected abstract SOAPMessage createMessage(OperationMetaData var1) throws SOAPException;

    @Override
    public SOAPMessage bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv) throws BindingException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug((Object)("bindRequestMessage: " + opMetaData.getQName()));
        }
        try {
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            assert (msgContext != null);
            SOAPMessage reqMessage = this.createMessage(opMetaData);
            msgContext.setSOAPMessage(reqMessage);
            SOAPEnvelope soapEnvelope = reqMessage.getSOAPPart().getEnvelope();
            SOAPBody soapBody = soapEnvelope.getBody();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            Style style = opMetaData.getStyle();
            Object soapBodyElement = soapBody;
            if (style == Style.RPC) {
                QName opQName = opMetaData.getQName();
                Name opName = SOAPUtils.newName(namespaceRegistry.registerQName(opQName), soapEnvelope);
                if (debugEnabled) {
                    this.log.debug((Object)("Create RPC body element: " + opName));
                }
                soapBodyElement = new SOAPBodyElementRpc(opName);
                soapBodyElement = (SOAPBodyElement)soapBody.addChildElement((SOAPElement)soapBodyElement);
                if (opMetaData.getUse() == Use.ENCODED) {
                    String envURI = soapEnvelope.getNamespaceURI();
                    String envPrefix = soapEnvelope.getPrefix();
                    soapBodyElement.setAttributeNS(envURI, envPrefix + ":encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
                }
            }
            for (ParameterMetaData paramMetaData : opMetaData.getInputParameters()) {
                QName xmlName = paramMetaData.getXmlName();
                Object value = epInv.getRequestParamValue(xmlName);
                if (paramMetaData.isSwA()) {
                    AttachmentPart part = this.createAttachmentPart(paramMetaData, value);
                    reqMessage.addAttachmentPart(part);
                    continue;
                }
                SOAPHeader soapElement = paramMetaData.isInHeader() ? soapHeader : soapBodyElement;
                this.addParameterToMessage(paramMetaData, value, (SOAPElement)soapElement, soapEnvelope);
            }
            this.setSOAPActionHeader(opMetaData, reqMessage);
            return reqMessage;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public abstract void setSOAPActionHeader(OperationMetaData var1, SOAPMessage var2);

    @Override
    public EndpointInvocation unbindRequestMessage(OperationMetaData opMetaData, SOAPMessage payload) throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unbindRequestMessage: " + opMetaData.getQName()));
        }
        try {
            SOAPMessage reqMessage = payload;
            SOAPEnvelope soapEnvelope = reqMessage.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            SOAPBody soapBody = soapEnvelope.getBody();
            this.verifySOAPVersion(opMetaData, soapEnvelope);
            EndpointInvocation epInv = new EndpointInvocation(opMetaData);
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            assert (msgContext != null);
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            if (!opMetaData.isMessageEndpoint()) {
                Style style = opMetaData.getStyle();
                SOAPBody payloadParent = soapBody;
                if (style == Style.RPC) {
                    payloadParent = null;
                    Iterator it = soapBody.getChildElements();
                    while (payloadParent == null && it.hasNext()) {
                        Object childNode = it.next();
                        if (!(childNode instanceof SOAPElement)) continue;
                        payloadParent = (SOAPElement)childNode;
                    }
                    if (payloadParent == null) {
                        throw NativeMessages.MESSAGES.cannotFindRPCElement(soapBody);
                    }
                    QName elName = payloadParent.getElementQName();
                    elName = namespaceRegistry.registerQName(elName);
                }
                int numParameters = 0;
                for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                    SOAPHeader element;
                    QName xmlName = paramMetaData.getXmlName();
                    if (paramMetaData.getMode() == ParameterMode.OUT) {
                        epInv.setRequestParamValue(xmlName, null);
                        continue;
                    }
                    if (paramMetaData.isSwA()) {
                        AttachmentPart part = this.getAttachmentFromMessage(paramMetaData, reqMessage);
                        epInv.setRequestParamValue(xmlName, part);
                        continue;
                    }
                    boolean isHeader = paramMetaData.isInHeader();
                    Object object = element = isHeader ? soapHeader : payloadParent;
                    if (!isHeader) {
                        ++numParameters;
                    }
                    SOAPContentElement value = this.getParameterFromMessage(paramMetaData, (SOAPElement)element, false, soapEnvelope);
                    epInv.setRequestParamValue(xmlName, value);
                }
                int numChildElements = 0;
                Iterator itElements = payloadParent.getChildElements();
                while (itElements.hasNext()) {
                    Node node = (Node)itElements.next();
                    if (!(node instanceof SOAPElement)) continue;
                    ++numChildElements;
                }
                if (numChildElements != numParameters) {
                    throw NativeMessages.MESSAGES.invalidNumberOfPayloadElements(numChildElements);
                }
            } else {
                for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                    QName xmlName = paramMetaData.getXmlName();
                    Object value = soapBody.getChildElements().next();
                    epInv.setRequestParamValue(xmlName, value);
                }
            }
            return epInv;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public SOAPMessage bindResponseMessage(OperationMetaData opMetaData, EndpointInvocation epInv) throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("bindResponseMessage: " + opMetaData.getQName()));
        }
        try {
            ParameterMetaData retMetaData;
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            assert (msgContext != null);
            SOAPMessage resMessage = this.createMessage(opMetaData);
            msgContext.setSOAPMessage(resMessage);
            if (opMetaData.isOneWay()) {
                resMessage.getSOAPPart().setContent(null);
                return resMessage;
            }
            SOAPEnvelope soapEnvelope = resMessage.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            SOAPBody soapBody = soapEnvelope.getBody();
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            Style style = opMetaData.getStyle();
            Object soapBodyElement = soapBody;
            if (style == Style.RPC) {
                QName opQName = opMetaData.getResponseName();
                Name opName = SOAPUtils.newName(namespaceRegistry.registerQName(opQName), soapEnvelope);
                soapBodyElement = new SOAPBodyElementRpc(opName);
                soapBodyElement = (SOAPBodyElement)soapBody.addChildElement((SOAPElement)soapBodyElement);
                if (opMetaData.getUse() == Use.ENCODED) {
                    String envURI = soapEnvelope.getNamespaceURI();
                    String envPrefix = soapEnvelope.getPrefix();
                    soapBodyElement.setAttributeNS(envURI, envPrefix + ":encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
                }
            }
            if ((retMetaData = opMetaData.getReturnParameter()) != null) {
                Object value = epInv.getReturnValue();
                if (opMetaData.isDocumentWrapped()) {
                    value = ParameterWrapping.wrapResponseParameters(retMetaData, value, epInv.getOutParameters());
                }
                if (retMetaData.isSwA()) {
                    AttachmentPart part = this.createAttachmentPart(retMetaData, value);
                    resMessage.addAttachmentPart(part);
                    epInv.setReturnValue(part);
                } else {
                    SOAPContentElement soapElement = this.addParameterToMessage(retMetaData, value, (SOAPElement)soapBodyElement, soapEnvelope);
                    epInv.setReturnValue(soapElement);
                    soapElement.setObjectValue(value);
                }
            }
            for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters()) {
                QName xmlName = paramMetaData.getXmlName();
                Object value = epInv.getResponseParamValue(xmlName);
                if (paramMetaData.isSwA()) {
                    AttachmentPart part = this.createAttachmentPart(paramMetaData, value);
                    resMessage.addAttachmentPart(part);
                    continue;
                }
                if (paramMetaData.isInHeader()) {
                    this.addParameterToMessage(paramMetaData, value, (SOAPElement)soapHeader, soapEnvelope);
                    continue;
                }
                this.addParameterToMessage(paramMetaData, value, (SOAPElement)soapBodyElement, soapEnvelope);
            }
            return resMessage;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void unbindResponseMessage(OperationMetaData opMetaData, SOAPMessage payload, EndpointInvocation epInv) throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unbindResponseMessage: " + opMetaData.getQName()));
        }
        try {
            ParameterMetaData retMetaData;
            if (opMetaData.isOneWay()) {
                return;
            }
            SOAPMessage resMessage = payload;
            SOAPEnvelope soapEnvelope = resMessage.getSOAPPart().getEnvelope();
            if (soapEnvelope == null) {
                return;
            }
            this.verifySOAPVersion(opMetaData, soapEnvelope);
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            assert (msgContext != null);
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            SOAPBody soapBody = soapEnvelope.getBody();
            SOAPBodyElement soapBodyElement = SOAPUtils.getFirstSOAPBodyElement(soapBody);
            if (soapBodyElement instanceof SOAPFaultImpl) {
                this.throwFaultException((SOAPFaultImpl)soapBodyElement);
            }
            Style style = opMetaData.getStyle();
            SOAPBody soapElement = soapBody;
            if (style == Style.RPC) {
                if (soapBodyElement == null) {
                    throw NativeMessages.MESSAGES.emptySOAPBody();
                }
                soapElement = soapBodyElement;
            }
            if ((retMetaData = opMetaData.getReturnParameter()) != null) {
                if (retMetaData.isSwA()) {
                    AttachmentPart part = this.getAttachmentFromMessage(retMetaData, resMessage);
                    epInv.setReturnValue(part);
                } else {
                    SOAPContentElement value = this.getParameterFromMessage(retMetaData, (SOAPElement)soapElement, false, soapEnvelope);
                    epInv.setReturnValue(value);
                }
            }
            for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters()) {
                QName xmlName = paramMetaData.getXmlName();
                if (paramMetaData.isSwA()) {
                    AttachmentPart part = this.getAttachmentFromMessage(paramMetaData, resMessage);
                    epInv.setResponseParamValue(xmlName, part);
                    continue;
                }
                SOAPHeader element = paramMetaData.isInHeader() ? soapHeader : soapElement;
                SOAPContentElement value = this.getParameterFromMessage(paramMetaData, (SOAPElement)element, false, soapEnvelope);
                epInv.setResponseParamValue(xmlName, value);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public SOAPMessage bindFaultMessage(Exception ex) {
        SOAPMessage faultMessage = this.createFaultMessageFromException(ex);
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            msgContext.setSOAPMessage(faultMessage);
        }
        return faultMessage;
    }

    protected abstract SOAPMessage createFaultMessageFromException(Exception var1);

    private void verifySOAPVersion(OperationMetaData opMetaData, SOAPEnvelope soapEnvelope) {
        String envNS = soapEnvelope.getNamespaceURI();
        String bindingId = opMetaData.getEndpointMetaData().getBindingId();
        if (SOAP11HTTP_BINDING.equals(bindingId) && !"http://schemas.xmlsoap.org/soap/envelope/".equals(envNS)) {
            NativeLoggers.ROOT_LOGGER.unexpectedSoapEnvelopeVersion("1.1", envNS);
        }
        if (SOAP12HTTP_BINDING.equals(bindingId) && !"http://www.w3.org/2003/05/soap-envelope".equals(envNS)) {
            NativeLoggers.ROOT_LOGGER.unexpectedSoapEnvelopeVersion("1.2", envNS);
        }
    }

    private AttachmentPart createAttachmentPart(ParameterMetaData paramMetaData, Object value) throws SOAPException, BindingException {
        String partName = paramMetaData.getXmlName().getLocalPart();
        Set<String> mimeTypes = paramMetaData.getMimeTypes();
        AttachmentPartImpl part = new AttachmentPartImpl();
        if (value instanceof DataHandler) {
            DataHandler handler = (DataHandler)value;
            String mimeType = MimeUtils.getBaseMimeType(handler.getContentType());
            if (mimeTypes != null && !MimeUtils.isMemberOf(mimeType, mimeTypes)) {
                NativeLoggers.ROOT_LOGGER.mimeTypeNotAllowed(mimeType, paramMetaData.getXmlName(), mimeTypes);
            }
            part.setDataHandler((DataHandler)value);
        } else {
            String mimeType = null;
            mimeType = mimeTypes != null && mimeTypes.size() > 0 ? mimeTypes.iterator().next() : MimeUtils.resolveMimeType(value);
            if (mimeType == null) {
                throw NativeMessages.MESSAGES.couldNotDetermineMimeType(partName);
            }
            part.setContent(value, mimeType);
        }
        if (paramMetaData.isSwA()) {
            String swaCID = '<' + partName + "=" + CIDGenerator.generateFromCount() + '>';
            part.setContentId(swaCID);
        }
        return part;
    }

    private AttachmentPart getAttachmentFromMessage(ParameterMetaData paramMetaData, SOAPMessage message) throws SOAPException, BindingException {
        QName xmlName = paramMetaData.getXmlName();
        AttachmentPart part = this.getAttachmentByPartName(xmlName.getLocalPart(), message);
        if (part == null) {
            throw NativeMessages.MESSAGES.couldNotLocateAttachment(paramMetaData.getXmlName());
        }
        return part;
    }

    private AttachmentPart getAttachmentByPartName(String partName, SOAPMessage soapMsg) {
        Iterator i = soapMsg.getAttachments();
        while (i.hasNext()) {
            AttachmentPart part = (AttachmentPart)i.next();
            String contentId = part.getContentId();
            if (!contentId.startsWith("<" + partName + "=")) continue;
            return part;
        }
        return null;
    }

    private SOAPContentElement addParameterToMessage(ParameterMetaData paramMetaData, Object value, SOAPElement soapElement, SOAPEnvelope soapEnvelope) throws SOAPException, BindingException {
        SOAPContentElement contentElement;
        Class<?> valueType;
        QName xmlName = paramMetaData.getXmlName();
        Class<?> javaType = paramMetaData.getJavaType();
        if (value != null && !JavaUtils.isAssignableFrom(javaType, valueType = value.getClass())) {
            throw NativeMessages.MESSAGES.javaTypeIsNotAssignableFrom(javaType.getName(), valueType.getName());
        }
        if (xmlName.getNamespaceURI().length() > 0) {
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            xmlName = namespaceRegistry.registerQName(xmlName);
        }
        Name soapName = SOAPUtils.newName(xmlName, soapEnvelope);
        if (soapElement instanceof SOAPHeader) {
            contentElement = new SOAPHeaderElementImpl(soapName);
            soapElement.addChildElement((SOAPElement)contentElement);
        } else {
            Style style = paramMetaData.getOperationMetaData().getStyle();
            if (style == Style.DOCUMENT) {
                contentElement = new SOAPBodyElementDoc(soapName);
                soapElement.addChildElement((SOAPElement)contentElement);
            } else {
                contentElement = new SOAPContentElement(soapName);
                soapElement.addChildElement((SOAPElement)contentElement);
            }
        }
        contentElement.setParamMetaData(paramMetaData);
        if (paramMetaData.isSOAPArrayParam()) {
            this.log.trace((Object)"Add parameter as SOAP encoded Array");
            contentElement.addNamespaceDeclaration("soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");
        }
        contentElement.setObjectValue(value);
        return contentElement;
    }

    private SOAPContentElement getParameterFromMessage(ParameterMetaData paramMetaData, SOAPElement soapElement, boolean optional, SOAPEnvelope soapEnvelope) throws BindingException, SOAPException {
        QName soapArrayQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array", "soap11-enc");
        Name SOAP_ARRAY_NAME = SOAPUtils.newName(soapArrayQName, soapEnvelope);
        Name xmlName = SOAPUtils.newName(paramMetaData.getXmlName(), soapEnvelope);
        SOAPContentElement soapContentElement = null;
        Iterator childElements = soapElement.getChildElements();
        while (childElements.hasNext()) {
            Object childNode = childElements.next();
            if (!(childNode instanceof SOAPElement)) continue;
            SOAPElementImpl childElement = (SOAPElementImpl)childNode;
            if (!(childElement instanceof SOAPContentElement)) {
                childElement = (SOAPContentElement)((Object)soapElement.replaceChild((org.w3c.dom.Node)((Object)new SOAPContentElement(childElement)), (org.w3c.dom.Node)((Object)childElement)));
            }
            SOAPContentElement aux = (SOAPContentElement)childElement;
            Name elName = aux.getElementName();
            if (xmlName.getLocalName().equals("") || xmlName.equals(elName)) {
                soapContentElement = aux;
                soapContentElement.setParamMetaData(paramMetaData);
                break;
            }
            if (!SOAP_ARRAY_NAME.equals(elName)) continue;
            QName compXMLName = paramMetaData.getXmlName();
            Element compElement = DOMUtils.getFirstChildElement((org.w3c.dom.Node)((Object)aux));
            if (compElement != null && !compElement.getNodeName().equals(compXMLName.getLocalPart())) continue;
            soapContentElement = aux;
            soapContentElement.setParamMetaData(paramMetaData);
            break;
        }
        if (soapContentElement == null) {
            childElements = soapElement.getChildElements();
            OperationMetaData opMetaData = paramMetaData.getOperationMetaData();
            TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
            SOAPElement childElement = null;
            while (childElement == null && childElements.hasNext()) {
                Object current = childElements.next();
                if (!(current instanceof SOAPElement)) continue;
                childElement = (SOAPElement)current;
            }
            if (childElement != null && opMetaData.getStyle() == Style.DOCUMENT) {
                SOAPContentElement aux = (SOAPContentElement)childElement;
                Name elName = aux.getElementName();
                QName elType = null;
                XSElementDeclaration xsdElement = typesMetaData.getSchemaModel().getElementDeclaration(elName.getLocalName(), elName.getURI());
                if (xsdElement != null && xsdElement.getTypeDefinition() != null) {
                    XSTypeDefinition xsdType = xsdElement.getTypeDefinition();
                    elType = new QName(xsdType.getNamespace(), xsdType.getName());
                }
                if (paramMetaData.getXmlType().equals(elType)) {
                    soapContentElement = aux;
                    soapContentElement.setParamMetaData(paramMetaData);
                }
            }
        }
        if (soapContentElement == null && !optional) {
            throw NativeMessages.MESSAGES.cannotFindChildElement(xmlName);
        }
        return soapContentElement;
    }

    protected abstract void throwFaultException(SOAPFaultImpl var1) throws Exception;

    protected abstract void verifyUnderstoodHeader(SOAPHeaderElement var1) throws Exception;

    public void checkMustUnderstand(OperationMetaData opMetaData) throws Exception {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        assert (msgContext != null);
        SOAPMessage soapMessage = msgContext.getSOAPMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        if (soapEnvelope == null || soapEnvelope.getHeader() == null) {
            return;
        }
        Iterator it = soapEnvelope.getHeader().examineAllHeaderElements();
        while (it.hasNext()) {
            SOAPHeaderElement soapHeaderElement = (SOAPHeaderElement)it.next();
            Name name = soapHeaderElement.getElementName();
            QName xmlName = new QName(name.getURI(), name.getLocalName());
            ParameterMetaData paramMetaData = opMetaData != null ? opMetaData.getParameter(xmlName) : null;
            boolean isBoundHeader = paramMetaData != null && paramMetaData.isInHeader();
            if (isBoundHeader || !soapHeaderElement.getMustUnderstand()) continue;
            this.verifyUnderstoodHeader(soapHeaderElement);
        }
    }

    @Override
    public void setHeaderSource(HeaderSource source) {
        this.headerSource = source;
    }

    private void handleException(Exception ex) throws BindingException {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof BindingException) {
            throw (BindingException)ex;
        }
        throw new BindingException(ex);
    }
}

