/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.Base64;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WsHttpServletRequestWrapper;
import org.apache.tomcat.util.buf.EncodingToCharset;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.jboss.servlet.http.UpgradableHttpServletResponse;
import org.jboss.web.CatalinaMessages;

public abstract class WebSocketServlet
extends HttpServlet
implements HttpEventServlet {
    private static final long serialVersionUID = 1L;
    private static final byte[] WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(EncodingToCharset.ISO_8859_1);
    private final Queue<MessageDigest> sha1Helpers = new ConcurrentLinkedQueue<MessageDigest>();

    @Override
    public void event(HttpEvent event) throws IOException, ServletException {
        HttpServletRequest req = event.getHttpServletRequest();
        HttpServletResponse resp = event.getHttpServletResponse();
        switch (event.getType()) {
            case BEGIN: {
                String subProtocol = null;
                List extensions = Collections.emptyList();
                if (!this.headerContainsToken(req, "upgrade", "websocket")) {
                    resp.sendError(400);
                    return;
                }
                if (!this.headerContainsToken(req, "connection", "upgrade")) {
                    resp.sendError(400);
                    return;
                }
                if (!this.headerContainsToken(req, "sec-websocket-version", "13")) {
                    resp.setStatus(426);
                    resp.setHeader("Sec-WebSocket-Version", "13");
                    return;
                }
                String key = req.getHeader("Sec-WebSocket-Key");
                if (key == null) {
                    resp.sendError(400);
                    return;
                }
                String origin = req.getHeader("Origin");
                if (!this.verifyOrigin(origin)) {
                    resp.sendError(403);
                    return;
                }
                List<String> subProtocols = this.getTokensFromHeader(req, "Sec-WebSocket-Protocol");
                if (!subProtocols.isEmpty()) {
                    subProtocol = this.selectSubProtocol(subProtocols);
                }
                HttpServletResponse inner = resp;
                while (inner instanceof ServletResponseWrapper) {
                    inner = ((ServletResponseWrapper)inner).getResponse();
                }
                if (inner instanceof UpgradableHttpServletResponse) {
                    ((UpgradableHttpServletResponse)inner).startUpgrade();
                } else {
                    resp.sendError(500, CatalinaMessages.MESSAGES.errorUpgrading());
                }
                resp.setHeader("Upgrade", "websocket");
                resp.setHeader("Connection", "upgrade");
                resp.setHeader("Sec-WebSocket-Accept", this.getWebSocketAccept(key));
                if (subProtocol != null) {
                    resp.setHeader("Sec-WebSocket-Protocol", subProtocol);
                }
                if (!extensions.isEmpty()) {
                    // empty if block
                }
                WsHttpServletRequestWrapper wrapper = new WsHttpServletRequestWrapper(req);
                StreamInbound inbound = this.createWebSocketInbound(subProtocol, wrapper);
                inbound.setEvent(event);
                wrapper.invalidate();
                ((UpgradableHttpServletResponse)inner).sendUpgrade();
                inbound.onUpgradeComplete();
                req.setAttribute("websocket.inbound", (Object)inbound);
                break;
            }
            case END: {
                event.close();
                break;
            }
            case EOF: {
                break;
            }
            case ERROR: {
                event.close();
                break;
            }
            case EVENT: {
                break;
            }
            case READ: {
                StreamInbound inbound = (StreamInbound)req.getAttribute("websocket.inbound");
                do {
                    inbound.onData();
                } while (event.isReadReady());
                break;
            }
            case TIMEOUT: {
                break;
            }
        }
    }

    private boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getTokensFromHeader(HttpServletRequest req, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                result.add(token.trim());
            }
        }
        return result;
    }

    private String getWebSocketAccept(String key) throws ServletException {
        MessageDigest sha1Helper = this.sha1Helpers.poll();
        if (sha1Helper == null) {
            try {
                sha1Helper = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException((Throwable)e);
            }
        }
        sha1Helper.reset();
        sha1Helper.update(key.getBytes(EncodingToCharset.ISO_8859_1));
        String result = new String(Base64.encode(sha1Helper.digest(WS_ACCEPT)));
        this.sha1Helpers.add(sha1Helper);
        return result;
    }

    protected boolean verifyOrigin(String origin) {
        return true;
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        return null;
    }

    protected abstract StreamInbound createWebSocketInbound(String var1, HttpServletRequest var2);
}

