/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.compression;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.compression.ZlibUtil;
import org.jboss.netty.handler.codec.compression.ZlibWrapper;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.jboss.netty.util.internal.jzlib.JZlib;
import org.jboss.netty.util.internal.jzlib.ZStream;

public class ZlibDecoder
extends OneToOneDecoder {
    private final ZStream z = new ZStream();
    private byte[] dictionary;
    private volatile boolean finished;

    public ZlibDecoder() {
        this(ZlibWrapper.ZLIB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZlibDecoder(ZlibWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("wrapper");
        }
        ZStream zStream = this.z;
        synchronized (zStream) {
            int resultCode = this.z.inflateInit(ZlibUtil.convertWrapperType(wrapper));
            if (resultCode != 0) {
                ZlibUtil.fail(this.z, "initialization failure", resultCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZlibDecoder(byte[] dictionary) {
        if (dictionary == null) {
            throw new NullPointerException("dictionary");
        }
        this.dictionary = dictionary;
        ZStream zStream = this.z;
        synchronized (zStream) {
            int resultCode = this.z.inflateInit(JZlib.W_ZLIB);
            if (resultCode != 0) {
                ZlibUtil.fail(this.z, "initialization failure", resultCode);
            }
        }
    }

    public boolean isClosed() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer) || this.finished) {
            return msg;
        }
        ZStream zStream = this.z;
        synchronized (zStream) {
            try {
                ChannelBuffer compressed = (ChannelBuffer)msg;
                byte[] in = new byte[compressed.readableBytes()];
                compressed.readBytes(in);
                this.z.next_in = in;
                this.z.next_in_index = 0;
                this.z.avail_in = in.length;
                byte[] out = new byte[in.length << 1];
                ChannelBuffer decompressed = ChannelBuffers.dynamicBuffer(compressed.order(), out.length, ctx.getChannel().getConfig().getBufferFactory());
                this.z.next_out = out;
                this.z.next_out_index = 0;
                this.z.avail_out = out.length;
                block12: while (true) {
                    int resultCode = this.z.inflate(2);
                    if (this.z.next_out_index > 0) {
                        decompressed.writeBytes(out, 0, this.z.next_out_index);
                        this.z.avail_out = out.length;
                    }
                    this.z.next_out_index = 0;
                    switch (resultCode) {
                        case 2: {
                            if (this.dictionary == null) {
                                ZlibUtil.fail(this.z, "decompression failure", resultCode);
                                continue block12;
                            }
                            resultCode = this.z.inflateSetDictionary(this.dictionary, this.dictionary.length);
                            if (resultCode == 0) continue block12;
                            ZlibUtil.fail(this.z, "failed to set the dictionary", resultCode);
                            continue block12;
                        }
                        case 1: {
                            this.finished = true;
                            this.z.inflateEnd();
                            break block12;
                        }
                        case 0: {
                            continue block12;
                        }
                        case -5: {
                            if (this.z.avail_in > 0) continue block12;
                            break block12;
                        }
                        default: {
                            ZlibUtil.fail(this.z, "decompression failure", resultCode);
                            continue block12;
                        }
                    }
                    break;
                }
                if (decompressed.writerIndex() != 0) {
                    ChannelBuffer channelBuffer = decompressed;
                    return channelBuffer;
                }
                Object var9_11 = null;
                return var9_11;
            }
            finally {
                this.z.next_in = null;
                this.z.next_out = null;
            }
        }
    }
}

