/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.internal.FrameworkEventsImpl;
import org.jboss.osgi.framework.spi.ExecutorServicePlugin;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.osgi.framework.BundleContext;

final class FrameworkEventsPlugin
extends ExecutorServicePlugin<FrameworkEvents> {
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<LockManager> injectedLockManager = new InjectedValue();

    FrameworkEventsPlugin() {
        super(IntegrationServices.FRAMEWORK_EVENTS, "Framework Events Thread");
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkEvents> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(IntegrationServices.SYSTEM_CONTEXT_INTERNAL, BundleContext.class, this.injectedSystemContext);
        builder.addDependency(IntegrationServices.LOCK_MANAGER, LockManager.class, this.injectedLockManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected FrameworkEvents createServiceValue(StartContext startContext) throws StartException {
        LockManager lockManager = (LockManager)this.injectedLockManager.getValue();
        return new FrameworkEventsImpl(this.getBundleManager(), this.getExecutorService(), lockManager);
    }

    @Override
    public void stop(StopContext context) {
        FrameworkEvents events = (FrameworkEvents)this.getValue();
        events.removeAllBundleListeners();
        events.removeAllFrameworkListeners();
        events.removeAllServiceListeners();
    }
}

