/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractBundleWire;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.FutureServiceValue;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.NativeCode;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.felix.StatelessResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

public final class ResolverImpl
extends StatelessResolver
implements XResolver {
    private final BundleManagerPlugin bundleManager;
    private final NativeCode nativeCode;
    private final ModuleManager moduleManager;
    private final FrameworkModuleLoader moduleLoader;
    private final XEnvironment environment;
    private final LockManager lockManager;

    public ResolverImpl(BundleManager bundleManager, NativeCode nativeCode, ModuleManager moduleManager, FrameworkModuleLoader moduleLoader, XEnvironment environment, LockManager lockManager) {
        this.bundleManager = BundleManagerPlugin.assertBundleManagerPlugin(bundleManager);
        this.nativeCode = nativeCode;
        this.moduleManager = moduleManager;
        this.moduleLoader = moduleLoader;
        this.environment = environment;
        this.lockManager = lockManager;
    }

    public XResolveContext createResolveContext(XEnvironment environment, Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) {
        Collection<Resource> manres = this.filterSingletons(mandatory);
        HashSet<Resource> optres = new HashSet<Resource>(optional != null ? optional : Collections.emptySet());
        this.appendOptionalFragments(mandatory, optres);
        this.appendOptionalHostBundles(mandatory, optres);
        return super.createResolveContext(environment, manres, optres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<Resource, List<Wire>> resolve(ResolveContext resolveContext) throws ResolutionException {
        LockManager.LockContext lockContext = null;
        try {
            FrameworkWiringLock wireLock = this.lockManager.getItemForType(FrameworkWiringLock.class);
            lockContext = this.lockManager.lockItems(LockManager.Method.RESOLVE, wireLock);
            Map map = super.resolve(resolveContext);
            this.lockManager.unlockItems(lockContext);
            return map;
        }
        catch (Throwable throwable) {
            this.lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<Resource, Wiring> resolveAndApply(XResolveContext resolveContext) throws ResolutionException {
        Map<Resource, Wiring> wirings;
        Map wiremap;
        LockManager.LockContext lockContext = null;
        try {
            FrameworkWiringLock wireLock = this.lockManager.getItemForType(FrameworkWiringLock.class);
            lockContext = this.lockManager.lockItems(LockManager.Method.RESOLVE, wireLock);
            wiremap = super.resolve((ResolveContext)resolveContext);
            wirings = this.applyResolverResults(wiremap);
            this.lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            this.lockManager.unlockItems(lockContext);
            throw throwable;
        }
        this.sendBundleResolvedEvents(wiremap);
        return wirings;
    }

    private void appendOptionalFragments(Collection<? extends Resource> mandatory, Collection<Resource> optional) {
        Collection<Capability> hostcaps = this.getHostCapabilities(mandatory);
        if (!hostcaps.isEmpty()) {
            optional.addAll(this.findAttachableFragments(hostcaps));
        }
    }

    private void appendOptionalHostBundles(Collection<? extends Resource> mandatory, Collection<Resource> optional) {
        for (Resource resource : mandatory) {
            for (Requirement req : resource.getRequirements("osgi.wiring.package")) {
                XPackageRequirement preq = (XPackageRequirement)req;
                if (!preq.isOptional()) continue;
                for (XBundle bundle2 : this.bundleManager.getBundles(2)) {
                    XBundleRevision auxrev = bundle2.getBundleRevision();
                    if (bundle2.isFragment() || mandatory.contains(auxrev)) continue;
                    optional.add((Resource)auxrev);
                }
                return;
            }
        }
    }

    private Collection<Capability> getHostCapabilities(Collection<? extends Resource> resources) {
        HashSet<Capability> result = new HashSet<Capability>();
        for (Resource resource : resources) {
            List caps = resource.getCapabilities("osgi.wiring.host");
            if (caps.size() != 1) continue;
            result.add((Capability)caps.get(0));
        }
        return result;
    }

    private Collection<Resource> filterSingletons(Collection<? extends Resource> resources) {
        HashMap<String, XResource> singletons = new HashMap<String, XResource>();
        ArrayList<? extends Resource> result = new ArrayList<Resource>(resources);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            XResource xres = (XResource)iterator.next();
            XIdentityCapability icap = xres.getIdentityCapability();
            if (!icap.isSingleton()) continue;
            if (singletons.get(icap.getSymbolicName()) != null) {
                iterator.remove();
                continue;
            }
            singletons.put(icap.getSymbolicName(), xres);
        }
        return Collections.unmodifiableList(result);
    }

    private Collection<XResource> findAttachableFragments(Collection<? extends Capability> hostcaps) {
        HashSet<XResource> result = new HashSet<XResource>();
        for (XResource res : this.environment.getResources(new String[]{"osgi.fragment"})) {
            Requirement req = (Requirement)res.getRequirements("osgi.wiring.host").get(0);
            XRequirement xreq = (XRequirement)req;
            for (Capability capability : hostcaps) {
                if (!xreq.matches(capability)) continue;
                result.add(res);
            }
        }
        if (!result.isEmpty()) {
            FrameworkLogger.LOGGER.debugf("Adding attachable fragments: %s", result);
        }
        return result;
    }

    private Map<Resource, Wiring> applyResolverResults(Map<Resource, List<Wire>> wiremap) throws ResolutionException {
        LinkedHashMap<BundleRevision, List<BundleWire>> brevmap = new LinkedHashMap<BundleRevision, List<BundleWire>>();
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            ArrayList<AbstractBundleWire> bwires = new ArrayList<AbstractBundleWire>();
            ArrayList<AbstractBundleWire> wires = new ArrayList<AbstractBundleWire>();
            for (Wire wire : entry.getValue()) {
                AbstractBundleWire bwire = new AbstractBundleWire(wire);
                bwires.add(bwire);
                wires.add(bwire);
            }
            Resource res = entry.getKey();
            brevmap.put((BundleRevision)res, bwires);
            wiremap.put(res, wires);
        }
        this.attachFragmentsToHost(brevmap);
        try {
            this.resolveNativeCodeLibraries(brevmap);
        }
        catch (BundleException ex) {
            throw new ResolutionException((Throwable)ex);
        }
        this.addModules(brevmap);
        this.createModuleServices(brevmap);
        this.createBundleServices(brevmap);
        Map wirings = this.environment.updateWiring(wiremap);
        for (Map.Entry entry : wirings.entrySet()) {
            XBundleRevision res = (XBundleRevision)entry.getKey();
            res.addAttachment(Wiring.class, entry.getValue());
        }
        this.setBundleStatesToResolved(brevmap);
        return wirings;
    }

    private void attachFragmentsToHost(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (!brev.isFragment()) continue;
            FragmentBundleRevision fragRev = (FragmentBundleRevision)brev;
            for (BundleWire wire : entry.getValue()) {
                BundleCapability cap = wire.getCapability();
                if (!"osgi.wiring.host".equals(cap.getNamespace())) continue;
                HostBundleRevision hostRev = (HostBundleRevision)cap.getResource();
                fragRev.attachToHost(hostRev);
            }
        }
    }

    private void resolveNativeCodeLibraries(Map<BundleRevision, List<BundleWire>> wiremap) throws BundleException {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            UserBundleRevision userRev;
            Deployment deployment;
            NativeLibraryMetaData libMetaData;
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (!(brev instanceof UserBundleRevision) || (libMetaData = (NativeLibraryMetaData)(deployment = (userRev = (UserBundleRevision)brev).getDeployment()).getAttachment(NativeLibraryMetaData.class)) == null) continue;
            this.nativeCode.resolveNativeCode((XBundleRevision)userRev);
        }
    }

    private void addModules(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (brev.isFragment()) continue;
            List<BundleWire> wires = wiremap.get(brev);
            this.moduleManager.addModule(brev, wires);
        }
    }

    private void createModuleServices(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            List<BundleWire> wires = entry.getValue();
            XBundle bundle2 = brev.getBundle();
            if (bundle2 == null || bundle2.getBundleId() == 0L || brev.isFragment()) continue;
            this.moduleLoader.createModuleService(brev, wires);
        }
    }

    private void createBundleServices(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            ServiceName serviceName;
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            XBundle bundle2 = brev.getBundle();
            if (bundle2 == null || bundle2.getBundleId() == 0L || brev.isFragment()) continue;
            HostBundleRevision hostRev = HostBundleRevision.assertHostRevision((BundleRevision)brev);
            HostBundleState hostState = hostRev.getBundleState();
            BundleManager bundleManager = hostState.adapt(BundleManager.class);
            ServiceContainer serviceContainer = bundleManager.getServiceContainer();
            ServiceController controller = serviceContainer.getService(serviceName = hostState.getServiceName(4));
            if (controller != null) {
                FutureServiceValue future = new FutureServiceValue(controller, ServiceController.State.REMOVED);
                try {
                    future.get(10L, TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            hostRev.createResolvedService(hostState.getServiceTarget());
        }
    }

    private void setBundleStatesToResolved(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            Bundle bundle2 = entry.getKey().getBundle();
            if (!(bundle2 instanceof AbstractBundleState)) continue;
            AbstractBundleState bundleState = (AbstractBundleState)bundle2;
            bundleState.changeState(4, 0);
        }
    }

    private void sendBundleResolvedEvents(Map<Resource, List<Wire>> wiremap) {
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            XBundle bundle2 = brev.getBundle();
            if (!(bundle2 instanceof AbstractBundleState)) continue;
            AbstractBundleState bundleState = (AbstractBundleState)bundle2;
            if (!this.bundleManager.isFrameworkCreated()) continue;
            bundleState.fireBundleEvent(32);
        }
    }
}

