/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.FallbackLoader;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.ServiceReferenceComparator;
import org.jboss.osgi.framework.internal.ServiceReferenceWrapper;
import org.jboss.osgi.framework.internal.ServiceRegistrationWrapper;
import org.jboss.osgi.framework.spi.ServiceManager;
import org.jboss.osgi.framework.spi.ServiceState;
import org.jboss.osgi.metadata.CaseInsensitiveDictionary;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.spi.ConstantsHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

final class ServiceStateImpl
implements ServiceState {
    private final ServiceManager serviceManager;
    private final XBundle ownerBundle;
    private final String[] classNames;
    private final long serviceId;
    private final ServiceState.ValueProvider valueProvider;
    private final ServiceReference reference;
    private ServiceRegistration registration;
    private Set<XBundle> usingBundles;
    private Map<Long, ServiceFactoryHolder> factoryValues;
    private CaseInsensitiveDictionary prevProperties;
    private CaseInsensitiveDictionary currProperties;

    ServiceStateImpl(ServiceManager serviceManager, XBundle owner, long serviceId, String[] classNames, ServiceState.ValueProvider valueProvider, Dictionary properties) {
        assert (serviceManager != null) : "Null serviceManager";
        assert (owner != null) : "Null owner";
        assert (classNames != null && classNames.length > 0) : "Null clazzes";
        assert (valueProvider != null) : "Null valueProvider";
        this.serviceManager = serviceManager;
        this.ownerBundle = owner;
        this.serviceId = serviceId;
        this.valueProvider = valueProvider;
        this.classNames = classNames;
        if (!valueProvider.isFactoryValue() && !this.checkValidClassNames(owner, classNames, valueProvider.getValue())) {
            throw FrameworkMessages.MESSAGES.illegalArgumentInvalidObjectClass(Arrays.toString(classNames));
        }
        if (properties == null) {
            properties = new Hashtable<String, Long>();
        }
        ((Dictionary)properties).put("service.id", serviceId);
        ((Dictionary)properties).put("objectClass", (Long)classNames);
        this.currProperties = new CaseInsensitiveDictionary(properties);
        this.registration = new ServiceRegistrationWrapper(this);
        this.reference = new ServiceReferenceWrapper(this);
    }

    static ServiceStateImpl assertServiceState(ServiceReference sref) {
        assert (sref != null) : "Null sref";
        if (sref instanceof ServiceReferenceWrapper) {
            sref = ((ServiceReferenceWrapper)sref).getServiceState();
        }
        return (ServiceStateImpl)sref;
    }

    @Override
    public long getServiceId() {
        return this.serviceId;
    }

    @Override
    public Object getScopedValue(XBundle bundle2) {
        if (!this.valueProvider.isFactoryValue()) {
            return this.valueProvider.getValue();
        }
        Object result = null;
        try {
            ServiceFactoryHolder factoryHolder;
            if (this.factoryValues == null) {
                this.factoryValues = new HashMap<Long, ServiceFactoryHolder>();
            }
            if ((factoryHolder = this.getFactoryHolder(bundle2)) == null) {
                ServiceFactory factory = (ServiceFactory)this.valueProvider.getValue();
                factoryHolder = new ServiceFactoryHolder(bundle2, factory);
                this.factoryValues.put(bundle2.getBundleId(), factoryHolder);
            }
            if ((result = factoryHolder.getService()) == null) {
                ServiceException sex = new ServiceException("Cannot get factory value", 2);
                this.serviceManager.fireFrameworkEvent(bundle2, 2, sex);
            }
        }
        catch (Throwable th) {
            ServiceException sex = new ServiceException("Cannot get factory value", 3, th);
            this.serviceManager.fireFrameworkEvent(bundle2, 2, sex);
        }
        return result;
    }

    @Override
    public void ungetScopedValue(XBundle bundle2) {
        ServiceFactoryHolder factoryHolder;
        if (this.valueProvider.isFactoryValue() && (factoryHolder = this.getFactoryHolder(bundle2)) != null) {
            try {
                factoryHolder.ungetService();
            }
            catch (RuntimeException rte) {
                ServiceException sex = new ServiceException("Cannot unget factory value", 3, (Throwable)rte);
                this.serviceManager.fireFrameworkEvent(bundle2, 16, sex);
            }
        }
    }

    private ServiceFactoryHolder getFactoryHolder(XBundle bundle2) {
        return this.factoryValues != null ? this.factoryValues.get(bundle2.getBundleId()) : null;
    }

    @Override
    public ServiceRegistration getRegistration() {
        return this.registration;
    }

    @Override
    public List<String> getClassNames() {
        return Arrays.asList(this.classNames);
    }

    public ServiceReference getReference() {
        this.assertNotUnregistered();
        return this.reference;
    }

    public void unregister() {
        this.assertNotUnregistered();
        this.unregisterInternal();
    }

    @Override
    public void unregisterInternal() {
        this.serviceManager.unregisterService(this);
        this.usingBundles = null;
        this.registration = null;
    }

    public Object getProperty(String key) {
        if (key == null) {
            return null;
        }
        return this.currProperties.get((Object)key);
    }

    public String[] getPropertyKeys() {
        ArrayList result = new ArrayList();
        if (this.currProperties != null) {
            Enumeration keys = this.currProperties.keys();
            while (keys.hasMoreElements()) {
                result.add(keys.nextElement());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setProperties(Dictionary properties) {
        this.assertNotUnregistered();
        this.prevProperties = this.currProperties;
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        ((Dictionary)properties).put("service.id", this.currProperties.get((Object)"service.id"));
        ((Dictionary)properties).put("objectClass", this.currProperties.get((Object)"objectClass"));
        this.currProperties = new CaseInsensitiveDictionary(properties);
        this.serviceManager.fireServiceEvent(this.ownerBundle, 2, this);
    }

    @Override
    public Dictionary getPreviousProperties() {
        return this.prevProperties;
    }

    @Override
    public XBundle getServiceOwner() {
        return this.ownerBundle;
    }

    public Bundle getBundle() {
        if (this.isUnregistered()) {
            return null;
        }
        return this.ownerBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUsingBundle(XBundle bundleState) {
        ServiceStateImpl serviceStateImpl = this;
        synchronized (serviceStateImpl) {
            if (this.usingBundles == null) {
                this.usingBundles = new HashSet<XBundle>();
            }
            this.usingBundles.add(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUsingBundle(XBundle bundle2) {
        ServiceStateImpl serviceStateImpl = this;
        synchronized (serviceStateImpl) {
            if (this.usingBundles != null) {
                this.usingBundles.remove(bundle2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<XBundle> getUsingBundlesInternal() {
        ServiceStateImpl serviceStateImpl = this;
        synchronized (serviceStateImpl) {
            if (this.usingBundles == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(new HashSet<XBundle>(this.usingBundles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getUsingBundles() {
        ServiceStateImpl serviceStateImpl = this;
        synchronized (serviceStateImpl) {
            if (this.usingBundles == null) {
                return null;
            }
            HashSet<XBundle> bundles = new HashSet<XBundle>();
            for (XBundle aux : this.usingBundles) {
                bundles.add(aux);
            }
            return bundles.toArray(new Bundle[bundles.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssignableTo(Bundle bundle2, String className) {
        Class<?> serviceClass;
        Class<?> targetClass;
        block16: {
            if (bundle2 == null) {
                throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
            }
            if (className == null) {
                throw FrameworkMessages.MESSAGES.illegalArgumentNull("className");
            }
            if (bundle2 == this.ownerBundle || className.startsWith("java.")) {
                return true;
            }
            int bundleState = bundle2.getState();
            if (bundleState == 1) {
                return false;
            }
            XBundleRevision bundleRev = ((XBundle)bundle2).getBundleRevision();
            ModuleClassLoader bundleClassLoader = bundleRev.getModuleClassLoader();
            if (bundleClassLoader == null) {
                FrameworkLogger.LOGGER.infof("NO CLASSLOADER [%s,%s] for: %s", bundle2, ConstantsHelper.bundleState((int)bundleState), className);
                return false;
            }
            FallbackLoader fallbackLoader = null;
            if (bundleRev instanceof HostBundleRevision) {
                fallbackLoader = ((HostBundleRevision)bundleRev).getFallbackLoader();
            }
            try {
                if (fallbackLoader != null) {
                    try {
                        fallbackLoader.lockFallbackLoader();
                        fallbackLoader.setEnabled(false);
                        targetClass = bundleClassLoader.loadClass(className);
                        break block16;
                    }
                    finally {
                        fallbackLoader.setEnabled(true);
                        fallbackLoader.unlockFallbackLoader();
                    }
                }
                targetClass = bundleClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                FrameworkLogger.LOGGER.tracef("Requesting bundle [%s] cannot load class: %s", bundle2, className);
                return true;
            }
        }
        XBundleRevision ownerRev = this.ownerBundle.getBundleRevision();
        ModuleClassLoader ownerClassLoader = ownerRev.getModuleClassLoader();
        if (ownerClassLoader == null) {
            FrameworkLogger.LOGGER.tracef("Registrant bundle [%s] has no class loader for: %s", this.ownerBundle, className);
            return true;
        }
        try {
            serviceClass = ownerClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            FrameworkLogger.LOGGER.tracef("Registrant bundle [%s] cannot load class: %s", this.ownerBundle, className);
            return true;
        }
        if (targetClass != serviceClass) {
            FrameworkLogger.LOGGER.tracef("Not assignable: %s", className);
            return false;
        }
        return true;
    }

    public int compareTo(Object sref) {
        if (!(sref instanceof ServiceReference)) {
            throw FrameworkMessages.MESSAGES.illegalArgumentInvalidServiceRef(sref);
        }
        Comparator<ServiceReference> comparator = ServiceReferenceComparator.getInstance();
        return comparator.compare(this, (ServiceReference)sref);
    }

    @Override
    public int getServiceRanking() {
        Object prop = this.getProperty("service.ranking");
        if (!(prop instanceof Integer)) {
            return 0;
        }
        return (Integer)prop;
    }

    @Override
    public boolean isUnregistered() {
        return this.registration == null;
    }

    private void assertNotUnregistered() {
        if (this.isUnregistered()) {
            throw FrameworkMessages.MESSAGES.illegalStateServiceUnregistered(this);
        }
    }

    private boolean checkValidClassNames(XBundle bundleState, String[] classNames, Object value) {
        assert (bundleState != null) : "Null bundleState";
        assert (classNames != null && classNames.length > 0) : "Null service classes";
        assert (value != null) : "Null value";
        if (value instanceof ServiceFactory) {
            return true;
        }
        boolean result = true;
        for (String className : classNames) {
            if (className == null) {
                result = false;
                break;
            }
            try {
                Class<?> valueClass = value.getClass();
                Class<?> clazz = Class.forName(className, false, valueClass.getClassLoader());
                if (clazz.isAssignableFrom(valueClass)) continue;
                FrameworkLogger.LOGGER.errorServiceNotAssignable(className, clazz.getClassLoader(), valueClass.getName(), valueClass.getClassLoader());
                result = false;
            }
            catch (ClassNotFoundException ex) {
                FrameworkLogger.LOGGER.errorCannotLoadService(className, (Bundle)bundleState);
                result = false;
            }
            break;
        }
        return result;
    }

    public String toString() {
        Hashtable<String, List<String>> props = new Hashtable<String, List<String>>((Map<String, List<String>>)this.currProperties);
        String[] classes = (String[])props.get("objectClass");
        props.put("objectClass", Arrays.asList(classes));
        return "ServiceState" + props;
    }

    class ServiceFactoryHolder {
        ServiceFactory factory;
        XBundle bundle;
        AtomicInteger useCount;
        Object value;

        ServiceFactoryHolder(XBundle bundle2, ServiceFactory factory) {
            this.bundle = bundle2;
            this.factory = factory;
            this.useCount = new AtomicInteger();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getService() {
            if (this.useCount.get() == 0) {
                XBundle xBundle = this.bundle;
                synchronized (xBundle) {
                    Object retValue = this.factory.getService((Bundle)this.bundle, ServiceStateImpl.this.getRegistration());
                    if (retValue == null) {
                        return null;
                    }
                    if (!ServiceStateImpl.this.checkValidClassNames(ServiceStateImpl.this.ownerBundle, (String[])ServiceStateImpl.this.getProperty("objectClass"), retValue)) {
                        return null;
                    }
                    this.value = retValue;
                }
            }
            this.useCount.incrementAndGet();
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ungetService() {
            if (this.useCount.get() == 0) {
                return;
            }
            if (this.useCount.decrementAndGet() == 0) {
                XBundle xBundle = this.bundle;
                synchronized (xBundle) {
                    this.factory.ungetService((Bundle)this.bundle, ServiceStateImpl.this.getRegistration(), this.value);
                    this.value = null;
                }
            }
        }
    }
}

