/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.PackageAdminImpl;
import org.jboss.osgi.framework.spi.ExecutorServicePlugin;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.PackageAdminSupport;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class PackageAdminPlugin
extends ExecutorServicePlugin<PackageAdminSupport> {
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<FrameworkEvents> injectedFrameworkEvents = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<ModuleManager> injectedModuleManager = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private final InjectedValue<StartLevel> injectedStartLevel = new InjectedValue();
    private final InjectedValue<LockManager> injectedLockManager = new InjectedValue();
    private ServiceRegistration registration;

    public PackageAdminPlugin() {
        super(Services.PACKAGE_ADMIN, "PackageAdmin Refresh Thread");
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<PackageAdminSupport> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(Services.START_LEVEL, StartLevel.class, this.injectedStartLevel);
        builder.addDependency(IntegrationServices.FRAMEWORK_EVENTS, FrameworkEvents.class, this.injectedFrameworkEvents);
        builder.addDependency(IntegrationServices.MODULE_MANGER, ModuleManager.class, this.injectedModuleManager);
        builder.addDependency(IntegrationServices.LOCK_MANAGER, LockManager.class, this.injectedLockManager);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.addDependency(Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = systemContext.registerService(PackageAdmin.class.getName(), this.getValue(), null);
    }

    @Override
    protected PackageAdminSupport createServiceValue(StartContext startContext) throws StartException {
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        FrameworkEvents events = (FrameworkEvents)this.injectedFrameworkEvents.getValue();
        ModuleManager moduleManager = (ModuleManager)this.injectedModuleManager.getValue();
        XResolver resolver = (XResolver)this.injectedResolver.getValue();
        StartLevel startLevel = (StartLevel)this.injectedStartLevel.getValue();
        LockManager lockManager = (LockManager)this.injectedLockManager.getValue();
        return new PackageAdminImpl(this.getBundleManager(), env, events, moduleManager, resolver, startLevel, lockManager, this.getExecutorService(), new AtomicBoolean(false));
    }

    @Override
    public void stop(StopContext context) {
        this.registration.unregister();
        super.stop(context);
    }
}

