/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.StartLevelImpl;
import org.jboss.osgi.framework.spi.ExecutorServicePlugin;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StartLevelSupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelPlugin
extends ExecutorServicePlugin<StartLevelSupport> {
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<FrameworkEvents> injectedFrameworkEvents = new InjectedValue();
    private ServiceRegistration registration;

    public StartLevelPlugin() {
        super(Services.START_LEVEL, "StartLevel Thread");
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<StartLevelSupport> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(IntegrationServices.SYSTEM_CONTEXT_INTERNAL, BundleContext.class, this.injectedSystemContext);
        builder.addDependency(IntegrationServices.FRAMEWORK_EVENTS, FrameworkEvents.class, this.injectedFrameworkEvents);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = systemContext.registerService(StartLevel.class.getName(), this.getValue(), null);
    }

    @Override
    protected StartLevelSupport createServiceValue(StartContext startContext) throws StartException {
        FrameworkEvents events = (FrameworkEvents)this.injectedFrameworkEvents.getValue();
        return new StartLevelImpl(this.getBundleManager(), events, this.getExecutorService(), new AtomicBoolean(false));
    }

    @Override
    public void stop(StopContext context) {
        this.registration.unregister();
        super.stop(context);
    }
}

