/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.CallbackLookup;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDocInfo {
    private Document doc = null;
    private Crypto crypto = null;
    private List<Element> tokenList = null;
    private List<WSSecurityEngineResult> resultsList = null;
    private CallbackLookup callbackLookup = null;
    private Element securityHeader = null;

    public WSDocInfo(Document doc) {
        this.doc = doc != null && doc.getDocumentElement() != null ? doc.getDocumentElement().getOwnerDocument() : doc;
    }

    public void clear() {
        this.crypto = null;
        if (this.tokenList != null && this.tokenList.size() > 0) {
            this.tokenList.clear();
        }
        if (this.resultsList != null && this.resultsList.size() > 0) {
            this.resultsList.clear();
        }
        this.tokenList = null;
        this.resultsList = null;
    }

    public void addTokenElement(Element element) throws WSSecurityException {
        this.addTokenElement(element, true);
    }

    public void addTokenElement(Element element, boolean checkMultipleElements) throws WSSecurityException {
        if (this.tokenList == null) {
            this.tokenList = new ArrayList<Element>();
        }
        if (checkMultipleElements) {
            for (Element elem : this.tokenList) {
                if (!this.compareElementsById(element, elem)) continue;
                throw new WSSecurityException(4, "duplicateError");
            }
        }
        this.tokenList.add(element);
    }

    private boolean compareElementsById(Element firstElement, Element secondElement) {
        String id2;
        String id;
        if (firstElement.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id") && secondElement.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id") && (id = firstElement.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")).equals(id2 = secondElement.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"))) {
            return true;
        }
        if (firstElement.hasAttributeNS(null, "AssertionID") && secondElement.hasAttributeNS(null, "AssertionID") && (id = firstElement.getAttributeNS(null, "AssertionID")).equals(id2 = secondElement.getAttributeNS(null, "AssertionID"))) {
            return true;
        }
        return firstElement.hasAttributeNS(null, "ID") && secondElement.hasAttributeNS(null, "ID") && (id = firstElement.getAttributeNS(null, "ID")).equals(id2 = secondElement.getAttributeNS(null, "ID"));
    }

    public Element getTokenElement(String uri) {
        String id = uri;
        if (id == null) {
            return null;
        }
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        if (this.tokenList != null) {
            for (Element elem : this.tokenList) {
                String cId = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                String samlId = elem.getAttributeNS(null, "AssertionID");
                String samlId2 = elem.getAttributeNS(null, "ID");
                if (!(elem.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id") && id.equals(cId) || elem.hasAttribute("AssertionID") && id.equals(samlId)) && (!elem.hasAttribute("ID") || !id.equals(samlId2))) continue;
                return elem;
            }
        }
        return null;
    }

    public void setTokensOnContext(DOMCryptoContext context) {
        if (this.tokenList != null) {
            for (Element elem : this.tokenList) {
                WSSecurityUtil.storeElementInContext(context, elem);
            }
        }
    }

    public void addProtectionElement(Element element) {
        if (this.tokenList == null) {
            this.tokenList = new ArrayList<Element>();
        }
        this.tokenList.add(element);
    }

    public Element getProtectionElement(String uri) {
        return this.getTokenElement(uri);
    }

    public void addResult(WSSecurityEngineResult result) {
        if (this.resultsList == null) {
            this.resultsList = new ArrayList<WSSecurityEngineResult>();
        }
        this.resultsList.add(result);
    }

    public WSSecurityEngineResult getResult(String uri) {
        String id = uri;
        if (id == null) {
            return null;
        }
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        if (this.resultsList != null) {
            for (WSSecurityEngineResult result : this.resultsList) {
                String cId;
                if (result == null || !id.equals(cId = (String)result.get("id"))) continue;
                return result;
            }
        }
        return null;
    }

    public List<WSSecurityEngineResult> getResultsByTag(Integer tag) {
        ArrayList<WSSecurityEngineResult> foundResults = new ArrayList<WSSecurityEngineResult>();
        if (this.resultsList != null) {
            for (WSSecurityEngineResult result : this.resultsList) {
                if (result == null) continue;
                Integer resultTag = (Integer)result.get("action");
                if (tag.intValue() != resultTag.intValue()) continue;
                foundResults.add(result);
            }
        }
        return foundResults;
    }

    public WSSecurityEngineResult getResultByTag(Integer tag, String uri) {
        String id = uri;
        if (id == null) {
            return null;
        }
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        if (this.resultsList != null) {
            for (WSSecurityEngineResult result : this.resultsList) {
                if (result == null) continue;
                Integer resultTag = (Integer)result.get("action");
                String cId = (String)result.get("id");
                if (tag.intValue() != resultTag.intValue() || !id.equals(cId)) continue;
                return result;
            }
        }
        return null;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    public void setCallbackLookup(CallbackLookup callbackLookup) {
        this.callbackLookup = callbackLookup;
    }

    public CallbackLookup getCallbackLookup() {
        return this.callbackLookup;
    }

    public Element getSecurityHeader() {
        return this.securityHeader;
    }

    public void setSecurityHeader(Element securityHeader) {
        this.securityHeader = securityHeader;
    }
}

