/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;

public class UsernameTokenValidator
implements Validator {
    private static Log log = LogFactory.getLog(UsernameTokenValidator.class);

    @Override
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getUsernametoken() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        boolean handleCustomPasswordTypes = false;
        boolean passwordsAreEncoded = false;
        String requiredPasswordType = null;
        WSSConfig wssConfig = data.getWssConfig();
        if (wssConfig != null) {
            handleCustomPasswordTypes = wssConfig.getHandleCustomPasswordTypes();
            passwordsAreEncoded = wssConfig.getPasswordsAreEncoded();
            requiredPasswordType = wssConfig.getRequiredPasswordType();
        }
        UsernameToken usernameToken = credential.getUsernametoken();
        usernameToken.setPasswordsAreEncoded(passwordsAreEncoded);
        String pwType = usernameToken.getPasswordType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("UsernameToken user " + usernameToken.getName()));
            log.debug((Object)("UsernameToken password type " + pwType));
        }
        if (requiredPasswordType != null && !requiredPasswordType.equals(pwType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authentication failed as the received password type does not match the required password type of: " + requiredPasswordType));
            }
            throw new WSSecurityException(5);
        }
        String password = usernameToken.getPassword();
        if (usernameToken.isHashed()) {
            this.verifyDigestPassword(usernameToken, data);
        } else if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(pwType) || password != null && (pwType == null || "".equals(pwType.trim()))) {
            this.verifyPlaintextPassword(usernameToken, data);
        } else if (password != null) {
            if (!handleCustomPasswordTypes) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Authentication failed as handleCustomUsernameTokenTypes is false");
                }
                throw new WSSecurityException(5);
            }
            this.verifyCustomPassword(usernameToken, data);
        } else {
            this.verifyUnknownPassword(usernameToken, data);
        }
        return credential;
    }

    protected void verifyCustomPassword(UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        this.verifyPlaintextPassword(usernameToken, data);
    }

    protected void verifyPlaintextPassword(UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        this.verifyDigestPassword(usernameToken, data);
    }

    protected void verifyDigestPassword(UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        String passDigest;
        if (data.getCallbackHandler() == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        String user = usernameToken.getName();
        String password = usernameToken.getPassword();
        String nonce = usernameToken.getNonce();
        String createdTime = usernameToken.getCreated();
        String pwType = usernameToken.getPasswordType();
        boolean passwordsAreEncoded = usernameToken.getPasswordsAreEncoded();
        WSPasswordCallback pwCb = new WSPasswordCallback(user, null, pwType, 2, data);
        try {
            data.getCallbackHandler().handle(new Callback[]{pwCb});
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            throw new WSSecurityException(5, null, null, e);
        }
        catch (UnsupportedCallbackException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            throw new WSSecurityException(5, null, null, e);
        }
        String origPassword = pwCb.getPassword();
        if (origPassword == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Callback supplied no password for: " + user));
            }
            throw new WSSecurityException(5);
        }
        if (usernameToken.isHashed() ? !(passDigest = passwordsAreEncoded ? UsernameToken.doPasswordDigest(nonce, createdTime, Base64.decode(origPassword)) : UsernameToken.doPasswordDigest(nonce, createdTime, origPassword)).equals(password) : !origPassword.equals(password)) {
            throw new WSSecurityException(5);
        }
    }

    protected void verifyUnknownPassword(UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        boolean allowUsernameTokenDerivedKeys = false;
        WSSConfig wssConfig = data.getWssConfig();
        if (wssConfig != null) {
            allowUsernameTokenDerivedKeys = wssConfig.isAllowUsernameTokenNoPassword();
        }
        if (!allowUsernameTokenDerivedKeys) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authentication failed as the received UsernameToken does not contain any password element");
            }
            throw new WSSecurityException(5);
        }
    }
}

