/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.value.Value;

final class ManagedReferenceFieldInjectionInterceptorFactory
implements InterceptorFactory {
    private final Object targetContextKey;
    private final Object valueContextKey;
    private final Value<ManagedReferenceFactory> factoryValue;
    private final Field field;
    private final boolean optional;

    ManagedReferenceFieldInjectionInterceptorFactory(Object targetContextKey, Object valueContextKey, Value<ManagedReferenceFactory> factoryValue, Field field, boolean optional) {
        this.targetContextKey = targetContextKey;
        this.valueContextKey = valueContextKey;
        this.factoryValue = factoryValue;
        this.field = field;
        this.optional = optional;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        Map contextData = context.getContextData();
        AtomicReference targetReference = (AtomicReference)contextData.get(this.targetContextKey);
        AtomicReference<ManagedReference> valueReference = new AtomicReference<ManagedReference>();
        contextData.put(this.valueContextKey, valueReference);
        return new ManagedReferenceFieldInjectionInterceptor(targetReference, valueReference, (ManagedReferenceFactory)this.factoryValue.getValue(), this.field, this.optional);
    }

    static final class ManagedReferenceFieldInjectionInterceptor
    implements Interceptor {
        private final AtomicReference<ManagedReference> targetReference;
        private final AtomicReference<ManagedReference> valueReference;
        private final ManagedReferenceFactory factory;
        private final Field field;
        private final boolean optional;

        ManagedReferenceFieldInjectionInterceptor(AtomicReference<ManagedReference> targetReference, AtomicReference<ManagedReference> valueReference, ManagedReferenceFactory factory, Field field, boolean optional) {
            this.targetReference = targetReference;
            this.valueReference = valueReference;
            this.factory = factory;
            this.field = field;
            this.optional = optional;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            Object target;
            if (Modifier.isStatic(this.field.getModifiers())) {
                target = null;
            } else {
                target = this.targetReference.get().getInstance();
                if (target == null) {
                    throw EeMessages.MESSAGES.injectionTargetNotFound();
                }
            }
            ManagedReference reference = this.factory.getReference();
            if (reference == null && this.optional) {
                return context.proceed();
            }
            if (reference == null) {
                throw EeMessages.MESSAGES.managedReferenceWasNull(this.field);
            }
            boolean ok = false;
            try {
                this.valueReference.set(reference);
                this.field.set(target, reference.getInstance());
                Object result = context.proceed();
                ok = true;
                Object object = result;
                return object;
            }
            finally {
                if (!ok) {
                    this.valueReference.set(null);
                    reference.release();
                }
            }
        }
    }
}

