/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.List;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class AroundInvokeAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static final DotName AROUND_INVOKE_ANNOTATION_NAME = DotName.createSimple((String)AroundInvoke.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        List aroundInvokes = index.getAnnotations(AROUND_INVOKE_ANNOTATION_NAME);
        for (AnnotationInstance annotation : aroundInvokes) {
            this.processAroundInvoke(eeModuleDescription, annotation.target());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processAroundInvoke(EEModuleDescription eeModuleDescription, AnnotationTarget target) throws DeploymentUnitProcessingException {
        if (!(target instanceof MethodInfo)) {
            throw EeMessages.MESSAGES.methodOnlyAnnotation(AROUND_INVOKE_ANNOTATION_NAME);
        }
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        ClassInfo classInfo = methodInfo.declaringClass();
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
        this.validateArgumentType(classInfo, methodInfo);
        InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder(classDescription.getInterceptorClassDescription());
        builder.setAroundInvoke(MethodIdentifier.getIdentifier(Object.class, (String)methodInfo.name(), (Class[])new Class[]{InvocationContext.class}));
        classDescription.setInterceptorClassDescription(builder.build());
    }

    private void validateArgumentType(ClassInfo classInfo, MethodInfo methodInfo) {
        Type[] args = methodInfo.args();
        switch (args.length) {
            case 0: {
                throw new IllegalArgumentException(EeMessages.MESSAGES.invalidSignature(methodInfo.name(), AROUND_INVOKE_ANNOTATION_NAME, classInfo.name(), "Object methodName(InvocationContext ctx)"));
            }
            case 1: {
                if (InvocationContext.class.getName().equals(args[0].name().toString())) break;
                throw new IllegalArgumentException(EeMessages.MESSAGES.invalidSignature(methodInfo.name(), AROUND_INVOKE_ANNOTATION_NAME, classInfo.name(), "Object methodName(InvocationContext ctx)"));
            }
            default: {
                throw new IllegalArgumentException(EeMessages.MESSAGES.invalidNumberOfArguments(methodInfo.name(), AROUND_INVOKE_ANNOTATION_NAME, classInfo.name()));
            }
        }
        if (!methodInfo.returnType().name().toString().equals(Object.class.getName())) {
            throw EeMessages.MESSAGES.invalidReturnType(Object.class.getName(), methodInfo.name(), AROUND_INVOKE_ANNOTATION_NAME, classInfo.name());
        }
    }
}

