/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJStreamWriter;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class MessageModeOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    MessageModeOutInterceptorInternal internal;
    SAAJOutInterceptor saajOut;
    Class<?> type;
    QName bindingName;

    public MessageModeOutInterceptor(SAAJOutInterceptor saajOut, QName bname) {
        super("prepare-send");
        this.saajOut = saajOut;
        this.bindingName = bname;
        this.internal = new MessageModeOutInterceptorInternal();
    }

    public MessageModeOutInterceptor(Class<?> t, QName bname) {
        super("prepare-send");
        this.type = t;
        this.bindingName = bname;
    }

    public void handleMessage(Message message) throws Fault {
        BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (bop != null && !this.bindingName.equals(bop.getBinding().getName())) {
            return;
        }
        if (this.saajOut != null) {
            this.doSoap(message);
        } else if (DataSource.class.isAssignableFrom(this.type)) {
            MessageContentsList list = (MessageContentsList)message.getContent(List.class);
            DataSource ds = (DataSource)list.get(0);
            String ct = ds.getContentType();
            if (ct.toLowerCase().contains("multipart/related")) {
                MessageImpl msg = new MessageImpl();
                msg.setExchange(message.getExchange());
                msg.put((Object)"Content-Type", (Object)ct);
                try {
                    msg.setContent(InputStream.class, (Object)ds.getInputStream());
                    AttachmentDeserializer deser = new AttachmentDeserializer((Message)msg);
                    deser.initializeAttachments();
                }
                catch (IOException ex) {
                    throw new Fault((Throwable)ex);
                }
                message.setAttachments(msg.getAttachments());
                final InputStream in = (InputStream)msg.getContent(InputStream.class);
                final String ct2 = (String)msg.get((Object)"Content-Type");
                list.set(0, (Object)new DataSource(){

                    public String getContentType() {
                        return ct2;
                    }

                    public InputStream getInputStream() throws IOException {
                        return in;
                    }

                    public String getName() {
                        return ct2;
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return null;
                    }
                });
            } else if (!ct.toLowerCase().contains("xml")) {
                OutputStream out = (OutputStream)message.getContent(OutputStream.class);
                message.put((Object)"Content-Type", (Object)ct);
                try {
                    InputStream in = ds.getInputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    in.close();
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
                list.remove(0);
                out = new CachedOutputStream();
                message.setContent(OutputStream.class, (Object)out);
                XMLStreamWriter writer = StaxUtils.createXMLStreamWriter((OutputStream)out);
                message.setContent(XMLStreamWriter.class, (Object)writer);
            }
        }
    }

    private void doSoap(Message message) {
        MessageContentsList list = (MessageContentsList)message.getContent(List.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        Object o = list.get(0);
        if (o instanceof SOAPMessage) {
            SOAPMessage soapMessage = (SOAPMessage)o;
            if (soapMessage.countAttachments() > 0) {
                message.put((Object)"write.attachments", (Object)Boolean.TRUE);
            }
            try {
                if (message instanceof SoapMessage) {
                    String namespace;
                    SoapMessage cxfSoapMessage = (SoapMessage)message;
                    String cxfNamespace = cxfSoapMessage.getVersion().getNamespace();
                    SOAPHeader soapHeader = soapMessage.getSOAPHeader();
                    String string = namespace = soapHeader == null ? null : soapHeader.getNamespaceURI();
                    if (namespace != null && cxfNamespace != null && !namespace.equals(cxfNamespace) && "http://www.w3.org/2003/05/soap-envelope".equals(namespace)) {
                        cxfSoapMessage.setVersion((SoapVersion)Soap12.getInstance());
                        cxfSoapMessage.put("Content-Type", (Object)cxfSoapMessage.getVersion().getContentType());
                    }
                }
            }
            catch (SOAPException e) {
                // empty catch block
            }
            try {
                Object enc = soapMessage.getProperty("javax.xml.soap.character-set-encoding");
                if (enc instanceof String) {
                    message.put((Object)Message.ENCODING, enc);
                }
            }
            catch (SOAPException e) {
                // empty catch block
            }
            try {
                Object xmlDec = soapMessage.getProperty("javax.xml.soap.write-xml-declaration");
                if (xmlDec != null) {
                    boolean b = MessageUtils.isTrue((Object)xmlDec);
                    message.put((Object)"org.apache.cxf.stax.force-start-document", (Object)b);
                }
            }
            catch (SOAPException e) {
                // empty catch block
            }
        }
        message.getInterceptorChain().add((Interceptor)this.internal);
    }

    private class MessageModeOutInterceptorInternal
    extends AbstractSoapInterceptor {
        MessageModeOutInterceptorInternal() {
            super("pre-protocol");
            this.addBefore(SAAJOutInterceptor.class.getName());
        }

        public void handleMessage(SoapMessage message) throws Fault {
            MessageContentsList list = (MessageContentsList)message.getContent(List.class);
            Object o = list.remove(0);
            SOAPMessage soapMessage = null;
            if (o instanceof SOAPMessage) {
                soapMessage = (SOAPMessage)o;
                if (soapMessage.countAttachments() > 0) {
                    message.put("write.attachments", (Object)Boolean.TRUE);
                }
            } else {
                try {
                    MessageFactory factory = MessageModeOutInterceptor.this.saajOut.getFactory(message);
                    soapMessage = factory.createMessage();
                    SOAPPart part = soapMessage.getSOAPPart();
                    if (o instanceof Source) {
                        StaxUtils.copy((Source)((Source)o), (XMLStreamWriter)new SAAJStreamWriter(part));
                    }
                }
                catch (SOAPException e) {
                    throw new SoapFault("Error creating SOAPMessage", (Throwable)e, message.getVersion().getSender());
                }
                catch (XMLStreamException e) {
                    throw new SoapFault("Error creating SOAPMessage", (Throwable)e, message.getVersion().getSender());
                }
            }
            message.setContent(SOAPMessage.class, (Object)soapMessage);
            if (!message.containsKey((Object)SAAJOutInterceptor.ORIGINAL_XML_WRITER)) {
                XMLStreamWriter origWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
                message.put(SAAJOutInterceptor.ORIGINAL_XML_WRITER, (Object)origWriter);
            }
            SAAJStreamWriter writer = new SAAJStreamWriter(soapMessage.getSOAPPart());
            message.setContent(XMLStreamWriter.class, (Object)writer);
            message.setContent(SOAPMessage.class, (Object)soapMessage);
            BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
            DocumentFragment frag = soapMessage.getSOAPPart().createDocumentFragment();
            try {
                SOAPBody body = SAAJUtils.getBody((SOAPMessage)soapMessage);
                Node nd = body.getFirstChild();
                while (nd != null) {
                    body.removeChild(nd);
                    frag.appendChild(nd);
                    nd = SAAJUtils.getBody((SOAPMessage)soapMessage).getFirstChild();
                }
                int index = 0;
                boolean client = this.isRequestor((Message)message);
                BindingMessageInfo bmsg = null;
                if (client) {
                    bmsg = bop.getInput();
                } else if (bop.getOutput() != null) {
                    bmsg = bop.getOutput();
                }
                if (bmsg != null && bmsg.getMessageParts() != null && bmsg.getMessageParts().size() > 0) {
                    index = ((MessagePartInfo)bmsg.getMessageParts().get(0)).getIndex();
                }
                list.set(index, (Object)frag);
                Object buffer = message.getContextualProperty("org.apache.cxf.output.buffering");
                if (buffer == null) {
                    message.put("org.apache.cxf.output.buffering", (Object)Boolean.FALSE);
                }
            }
            catch (Exception ex) {
                throw new Fault((Throwable)ex);
            }
            if (bop != null && bop.isUnwrapped()) {
                bop = bop.getWrappedOperation();
                message.getExchange().put(BindingOperationInfo.class, (Object)bop);
            }
            message.getInterceptorChain().add((Interceptor)SAAJOutInterceptor.SAAJOutEndingInterceptor.INSTANCE);
        }
    }
}

