/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.TypeClosureLazyValueHolder;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.introspector.jlr.AbstractWeldCallable;
import org.jboss.weld.introspector.jlr.ConstructorSignatureImpl;
import org.jboss.weld.introspector.jlr.WeldParameterImpl;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.SecureReflections;

public class WeldConstructorImpl<T>
extends AbstractWeldCallable<T, T, Constructor<T>>
implements WeldConstructor<T> {
    private static final Annotation[] EMPTY = new Annotation[0];
    private final Constructor<T> constructor;
    private final List<WeldParameter<?, T>> parameters;
    private final ConstructorSignature signature;

    public static <T> WeldConstructor<T> of(Constructor<T> constructor, WeldClass<T> declaringClass, ClassTransformer classTransformer) {
        return new WeldConstructorImpl<T>(constructor, constructor.getDeclaringClass(), constructor.getDeclaringClass(), null, new TypeClosureLazyValueHolder(constructor.getDeclaringClass()), WeldConstructorImpl.buildAnnotationMap(constructor.getAnnotations()), WeldConstructorImpl.buildAnnotationMap(constructor.getDeclaredAnnotations()), declaringClass, classTransformer);
    }

    public static <T> WeldConstructor<T> of(AnnotatedConstructor<T> annotatedConstructor, WeldClass<T> declaringClass, ClassTransformer classTransformer) {
        return new WeldConstructorImpl(annotatedConstructor.getJavaMember(), annotatedConstructor.getJavaMember().getDeclaringClass(), annotatedConstructor.getBaseType(), annotatedConstructor, new TypeClosureLazyValueHolder(annotatedConstructor.getTypeClosure()), WeldConstructorImpl.buildAnnotationMap(annotatedConstructor.getAnnotations()), WeldConstructorImpl.buildAnnotationMap(annotatedConstructor.getAnnotations()), declaringClass, classTransformer);
    }

    private WeldConstructorImpl(Constructor<T> constructor, Class<T> rawType, Type type, AnnotatedConstructor<T> annotatedConstructor, LazyValueHolder<Set<Type>> typeClosure, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, WeldClass<T> declaringClass, ClassTransformer classTransformer) {
        super(annotationMap, declaredAnnotationMap, classTransformer, constructor, rawType, type, typeClosure, declaringClass);
        this.constructor = constructor;
        this.parameters = new ArrayList();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (annotatedConstructor == null) {
            this.processParameters(classTransformer, parameterTypes);
        } else {
            if (annotatedConstructor.getParameters().size() != parameterTypes.length) {
                throw new DefinitionException(ReflectionMessage.INCORRECT_NUMBER_OF_ANNOTATED_PARAMETERS_METHOD, annotatedConstructor.getParameters().size(), annotatedConstructor, annotatedConstructor.getParameters(), Arrays.asList(parameterTypes));
            }
            for (AnnotatedParameter annotatedParameter : annotatedConstructor.getParameters()) {
                WeldParameter parameter = WeldParameterImpl.of(annotatedParameter.getAnnotations(), parameterTypes[annotatedParameter.getPosition()], annotatedParameter.getBaseType(), this, annotatedParameter.getPosition(), classTransformer);
                this.parameters.add(parameter);
            }
        }
        this.signature = new ConstructorSignatureImpl(this);
    }

    private void processParameters(ClassTransformer classTransformer, Class<?>[] parameterTypes) {
        Annotation[][] parameterAnnotations = this.constructor.getParameterAnnotations();
        Type[] genericParameterTypes = this.constructor.getGenericParameterTypes();
        int numberOfMissingGenericParameters = parameterTypes.length - genericParameterTypes.length;
        int numberOfMissingParameterAnnotations = parameterTypes.length - parameterAnnotations.length;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = i < numberOfMissingGenericParameters ? parameterTypes[i] : genericParameterTypes[i - numberOfMissingGenericParameters];
            Annotation[] annotations = i < numberOfMissingParameterAnnotations ? EMPTY : parameterAnnotations[i - numberOfMissingParameterAnnotations];
            this.parameters.add(WeldParameterImpl.of(annotations, parameterTypes[i], parameterType, this, i, classTransformer));
        }
    }

    public Constructor<T> getAnnotatedConstructor() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getDelegate() {
        return this.constructor;
    }

    @Override
    public List<WeldParameter<?, T>> getWeldParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<WeldParameter<?, T>> getWeldParameters(Class<? extends Annotation> annotationType) {
        ArrayList ret = new ArrayList();
        for (WeldParameter<?, T> parameter : this.parameters) {
            if (!parameter.isAnnotationPresent(annotationType)) continue;
            ret.add(parameter);
        }
        return ret;
    }

    @Override
    public T newInstance(Object ... parameters) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ((Constructor)SecureReflections.ensureAccessible(this.getDelegate())).newInstance(parameters);
    }

    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof WeldConstructor) {
            WeldConstructor that = (WeldConstructor)other;
            return ((Constructor)this.getJavaMember()).equals(that.getJavaMember()) && ((Object)this.getWeldParameters()).equals(that.getWeldParameters());
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + ((Constructor)this.getJavaMember()).hashCode();
        hash = hash * 31 + ((Object)this.getWeldParameters()).hashCode();
        return hash;
    }

    @Override
    public String toString() {
        return "[constructor] " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(this.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(((Constructor)this.getJavaMember()).getModifiers())) + this.getDeclaringType().getName() + Formats.formatAsFormalParameterList(this.getWeldParameters());
    }

    @Override
    public ConstructorSignature getSignature() {
        return this.signature;
    }

    public List<AnnotatedParameter<T>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public boolean isGeneric() {
        return ((Constructor)this.getJavaMember()).getTypeParameters().length > 0;
    }
}

