/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.jdbc.accessors;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataSourceJDBCAccess
implements JDBCAccess {
    private String datasourceName;

    @Override
    public Connection getConnection() throws SQLException, NamingException {
        Connection connection = ((DataSource)new InitialContext().lookup(this.datasourceName)).getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public void initialise(StringTokenizer tokenizer) {
        while (tokenizer.hasMoreElements()) {
            try {
                String[] split = tokenizer.nextToken().split("=");
                if (!split[0].equalsIgnoreCase("datasourceName")) continue;
                this.datasourceName = split[1];
            }
            catch (Exception ex) {
                throw new FatalError(this.toString() + " : " + ex, ex);
            }
        }
        if (this.datasourceName == null) {
            throw new FatalError("The JDBC ObjectStore was not configured with a datasource name");
        }
    }
}

