/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts;

import com.arjuna.ArjunaOTS.ActionControl;
import com.arjuna.ArjunaOTS.ActionControlHelper;
import com.arjuna.ArjunaOTS.ActiveThreads;
import com.arjuna.ArjunaOTS.ActiveTransaction;
import com.arjuna.ArjunaOTS.BadControl;
import com.arjuna.ArjunaOTS.Destroyed;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.internal.jts.PseudoControlWrapper;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.TransactionFactoryImple;
import com.arjuna.ats.internal.jts.utils.Helper;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.ORB;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.TransactionFactory;

public class OTSManager {
    public static final int serviceId = -559038737;
    private static int _localSlotId = -1;
    private static int _receivedSlotId = -1;

    public static Current get_current() throws SystemException {
        return OTSImpleManager.get_current();
    }

    public static TransactionFactoryImple factory() throws SystemException {
        return OTSImpleManager.factory();
    }

    public static TransactionFactory get_factory() throws SystemException {
        return OTSImpleManager.get_factory();
    }

    public static void destroyControl(ControlImple control) throws ActiveTransaction, ActiveThreads, BadControl, Destroyed, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("OTS::destroyControl ( " + control + " )"));
        }
        if (control == null) {
            throw new BadControl();
        }
        Coordinator coord = null;
        try {
            coord = control.get_coordinator();
        }
        catch (Exception e) {
            coord = null;
        }
        if (coord != null) {
            try {
                if (coord.is_top_level_transaction()) {
                    if (jtsLogger.logger.isTraceEnabled()) {
                        jtsLogger.logger.trace((Object)"OTS::destroyControl - removing control from reaper.");
                    }
                    PseudoControlWrapper wrapper = new PseudoControlWrapper(control);
                    TransactionReaper.transactionReaper().remove(wrapper);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            coord = null;
        }
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("OTS::destroyControl - local transaction: " + control.get_uid()));
        }
        control.destroy();
        control = null;
    }

    public static void destroyControl(Control control) throws ActiveTransaction, ActiveThreads, BadControl, Destroyed, SystemException {
        if (control == null) {
            throw new BadControl();
        }
        ControlImple lCont = Helper.localControl(control);
        if (lCont != null) {
            OTSManager.destroyControl(lCont);
        } else {
            Coordinator coord = null;
            try {
                coord = control.get_coordinator();
            }
            catch (Exception e) {
                coord = null;
            }
            if (coord != null) {
                try {
                    if (coord.is_top_level_transaction()) {
                        PseudoControlWrapper wrapper = new PseudoControlWrapper(control);
                        TransactionReaper.transactionReaper().remove(wrapper);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                coord = null;
            }
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace((Object)"OTS::destroyControl - remote control.");
            }
            ActionControl action = null;
            try {
                action = ActionControlHelper.narrow(control);
                if (action == null) {
                    throw new BAD_PARAM();
                }
            }
            catch (Exception e) {
                action = null;
            }
            if (action != null) {
                if (jtsLogger.logger.isTraceEnabled()) {
                    jtsLogger.logger.trace((Object)"OTS::destroyControl - Arjuna control.");
                }
                action.destroy();
                action = null;
                control = null;
            } else {
                control = null;
            }
        }
    }

    public static final void setLocalSlotId(int slotId) {
        _localSlotId = slotId;
    }

    public static final int getLocalSlotId() {
        return _localSlotId;
    }

    public static final void setReceivedSlotId(int slotId) {
        _receivedSlotId = slotId;
    }

    public static final int getReceivedSlotId() {
        return _receivedSlotId;
    }

    public static final void setORB(ORB theOrb) {
        ORBManager.setORB(theOrb);
    }

    public static final void setPOA(OA thePoa) {
        ORBManager.setPOA(thePoa);
    }
}

