/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.orbspecific.jacorb.interceptors.interposition;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.utils.ThreadUtil;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jts.common.InterceptorInfo;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.TransactionalObject;
import org.omg.CosTransactions.TransactionalObjectHelper;
import org.omg.CosTransactions.Unavailable;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;

class InterpositionClientRequestInterceptorImpl
extends LocalObject
implements ClientRequestInterceptor {
    private int _localSlot;
    private Codec _codec;
    private ThreadLocal _inUse = new ThreadLocal();

    public InterpositionClientRequestInterceptorImpl(int localSlot, Codec codec) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("InterpositionClientRequestInterceptorImpl ( " + localSlot + " )"));
        }
        this._localSlot = localSlot;
        this._codec = codec;
    }

    public String name() {
        return "OTS_Interposition";
    }

    private void trace_request(String method, ClientRequestInfo request_info) {
        jtsLogger.logger.tracef("InterpositionClientRequestInterceptorImpl::%s ( %s ) nodeId=%s requestId=%d", new Object[]{method, request_info.operation(), arjPropertyManager.getCoreEnvironmentBean().getNodeIdentifier(), request_info.request_id()});
    }

    public void send_request(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            this.trace_request("send_request", request_info);
        }
        if (this.systemCall(request_info)) {
            return;
        }
        boolean otsAlwaysPropagate = InterceptorInfo.getAlwaysPropagate();
        try {
            if (!otsAlwaysPropagate) {
                TransactionalObject ptr = TransactionalObjectHelper.narrow(request_info.target());
                if (ptr == null) {
                    throw new BAD_PARAM();
                }
            } else {
                if (this._inUse.get() != null) {
                    return;
                }
                this._inUse.set(this._inUse);
            }
            try {
                Any localData = request_info.get_slot(this._localSlot);
                String threadId = null;
                boolean problem = false;
                Any data = null;
                if (localData != null && localData.type().kind().value() != 0) {
                    threadId = localData.extract_string();
                    if (threadId == null) {
                        throw new UNKNOWN(jtsLogger.i18NLogger.get_orbspecific_jacorb_interceptors_interposition_invalidparam());
                    }
                } else {
                    threadId = ThreadUtil.getThreadId();
                }
                if (threadId != null) {
                    ControlWrapper theControl = OTSImpleManager.systemCurrent().contextManager().current(threadId);
                    if (theControl != null) {
                        try {
                            Coordinator theCoordinator = theControl.get_coordinator();
                            PropagationContext ctx = null;
                            if (theCoordinator == null) {
                                throw new Unavailable();
                            }
                            ctx = theCoordinator.get_txcontext();
                            data = this.packPropagationContext(ctx);
                            theCoordinator = null;
                        }
                        catch (Unavailable ex) {
                            problem = true;
                        }
                    } else {
                        problem = true;
                    }
                } else {
                    problem = true;
                }
                if (problem && InterceptorInfo.getNeedTranContext()) {
                    throw new TRANSACTION_REQUIRED();
                }
                if (data != null) {
                    byte[] octets = this._codec.encode_value(data);
                    ServiceContext service_context = new ServiceContext(-559038737, octets);
                    request_info.add_request_service_context(service_context, true);
                }
            }
            catch (SystemException e) {
                throw e;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new UNKNOWN(ex.toString());
            }
            finally {
                if (otsAlwaysPropagate) {
                    this._inUse.set(null);
                }
            }
        }
        catch (BAD_PARAM ex) {
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            // empty catch block
        }
    }

    public void send_poll(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            this.trace_request("send_poll", request_info);
        }
    }

    public void receive_reply(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            this.trace_request("receive_reply", request_info);
        }
    }

    public void receive_exception(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            this.trace_request("receive_exception", request_info);
        }
    }

    public void receive_other(ClientRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            this.trace_request("receive_other", request_info);
        }
    }

    private final Any packPropagationContext(PropagationContext ctx) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("InterpositionClientRequestInterceptorImpl.packPropagationContext ( " + ctx + " )"));
        }
        Any data = ORBManager.getORB().orb().create_any();
        if (ctx != null) {
            PropagationContextHelper.insert(data, ctx);
        }
        return data;
    }

    private final boolean systemCall(ClientRequestInfo request_info) {
        return "_is_a".equals(request_info.operation());
    }

    public void destroy() {
    }
}

