/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.policy.PolicyCalculator;
import org.apache.cxf.policy.PolicyDataEngine;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Assertor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.ContinuationProviderFactory;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.HttpServletRequestSnapshot;
import org.apache.cxf.transport.http.Servlet3ContinuationProvider;
import org.apache.cxf.transport.http.policy.impl.ServerPolicyCalculator;
import org.apache.cxf.transport.https.CertConstraints;
import org.apache.cxf.transport.https.CertConstraintsInterceptor;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.cxf.wsdl.WSDLLibrary;

public abstract class AbstractHTTPDestination
extends AbstractMultiplexDestination
implements Configurable,
Assertor {
    public static final String HTTP_REQUEST = "HTTP.REQUEST";
    public static final String HTTP_RESPONSE = "HTTP.RESPONSE";
    public static final String HTTP_CONTEXT = "HTTP.CONTEXT";
    public static final String HTTP_CONFIG = "HTTP.CONFIG";
    public static final String HTTP_CONTEXT_MATCH_STRATEGY = "HTTP_CONTEXT_MATCH_STRATEGY";
    public static final String RESPONSE_HEADERS_COPIED = "http.headers.copied";
    public static final String RESPONSE_COMMITED = "http.response.done";
    public static final String REQUEST_REDIRECTED = "http.request.redirected";
    public static final String CXF_CONTINUATION_MESSAGE = "cxf.continuation.message";
    public static final String CXF_ASYNC_CONTEXT = "cxf.async.context";
    public static final String SERVICE_REDIRECTION = "http.service.redirection";
    private static final String HTTP_BASE_PATH = "http.base.path";
    private static final String SSL_CIPHER_SUITE_ATTRIBUTE = "javax.servlet.request.cipher_suite";
    private static final String SSL_PEER_CERT_CHAIN_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractHTTPDestination.class);
    protected final Bus bus;
    protected DestinationRegistry registry;
    protected final String path;
    protected HTTPServerPolicy server;
    protected String contextMatchStrategy = "stem";
    protected boolean fixedParameterOrder;
    protected boolean multiplexWithAddress;
    protected CertConstraints certConstraints;
    protected boolean isServlet3;
    protected ContinuationProviderFactory cproviderFactory;

    public AbstractHTTPDestination(Bus b, DestinationRegistry registry, EndpointInfo ei, String path, boolean dp) throws IOException {
        super(b, AbstractHTTPDestination.getTargetReference((EndpointInfo)AbstractHTTPDestination.getAddressValue(ei, dp), (Bus)b), ei);
        this.bus = b;
        this.registry = registry;
        this.path = path;
        try {
            ServletRequest.class.getMethod("isAsyncSupported", new Class[0]);
            this.isServlet3 = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.initConfig();
    }

    public Bus getBus() {
        return this.bus;
    }

    private AuthorizationPolicy getAuthorizationPolicyFromMessage(String credentials, Principal pp) {
        if (credentials == null || StringUtils.isEmpty((String)credentials.trim())) {
            return null;
        }
        String[] creds = StringUtils.split((String)credentials, (String)" ");
        String authType = creds[0];
        if ("Basic".equals(authType)) {
            String authEncoded = creds[1];
            try {
                String authDecoded = new String(Base64Utility.decode((String)authEncoded));
                int idx = authDecoded.indexOf(58);
                String username = null;
                String password = null;
                if (idx == -1) {
                    username = authDecoded;
                } else {
                    username = authDecoded.substring(0, idx);
                    if (idx < authDecoded.length() - 1) {
                        password = authDecoded.substring(idx + 1);
                    }
                }
                AuthorizationPolicy policy = pp == null ? new AuthorizationPolicy() : new PrincipalAuthorizationPolicy(pp);
                policy.setUserName(username);
                policy.setPassword(password);
                policy.setAuthorizationType(authType);
                return policy;
            }
            catch (Base64Exception ex) {
                // empty catch block
            }
        }
        if (pp != null) {
            PrincipalAuthorizationPolicy policy = new PrincipalAuthorizationPolicy(pp);
            policy.setUserName(pp.getName());
            policy.setAuthorization(credentials);
            policy.setAuthorizationType(authType);
            return policy;
        }
        return null;
    }

    protected final boolean isOneWay(Message message) {
        Exchange ex = message.getExchange();
        return ex == null ? false : ex.isOneWay();
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block4: {
            Message inMessage = this.retrieveFromContinuation(req);
            if (inMessage == null) {
                LOG.fine("Create a new message for processing");
                inMessage = new MessageImpl();
                this.setupMessage(inMessage, config, context, req, resp);
                ExchangeImpl exchange = new ExchangeImpl();
                exchange.setInMessage(inMessage);
                exchange.setSession((Session)new HTTPSession(req));
                ((MessageImpl)inMessage).setDestination((Destination)this);
            } else {
                LOG.fine("Get the message from the request for processing");
            }
            this.copyKnownRequestAttributes(req, inMessage);
            try {
                this.incomingObserver.onMessage(inMessage);
            }
            catch (SuspendedInvocationException ex) {
                if (ex.getRuntimeException() == null) break block4;
                throw ex.getRuntimeException();
            }
        }
    }

    private void copyKnownRequestAttributes(HttpServletRequest request, Message message) {
        message.put((Object)SERVICE_REDIRECTION, request.getAttribute(SERVICE_REDIRECTION));
    }

    protected void setupMessage(Message inMessage, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setupMessage(inMessage, null, context, req, resp);
    }

    protected void setupMessage(final Message inMessage, ServletConfig config, ServletContext context, final HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int index;
        String servletPath;
        this.setupContinuation(inMessage, req, resp);
        DelegatingInputStream in = new DelegatingInputStream((InputStream)req.getInputStream()){

            public void cacheInput() {
                if (!this.cached && inMessage.getExchange().getOutMessage() == null) {
                    inMessage.put((Object)AbstractHTTPDestination.HTTP_REQUEST, (Object)new HttpServletRequestSnapshot(req));
                }
                super.cacheInput();
            }
        };
        inMessage.setContent(DelegatingInputStream.class, (Object)in);
        inMessage.setContent(InputStream.class, (Object)in);
        inMessage.put((Object)HTTP_REQUEST, (Object)req);
        inMessage.put((Object)HTTP_RESPONSE, (Object)resp);
        inMessage.put((Object)HTTP_CONTEXT, (Object)context);
        inMessage.put((Object)HTTP_CONFIG, (Object)config);
        inMessage.put((Object)HTTP_CONTEXT_MATCH_STRATEGY, (Object)this.contextMatchStrategy);
        inMessage.put((Object)"org.apache.cxf.request.method", (Object)req.getMethod());
        String requestURI = req.getRequestURI();
        inMessage.put((Object)"org.apache.cxf.request.uri", (Object)requestURI);
        String requestURL = req.getRequestURL().toString();
        inMessage.put((Object)"org.apache.cxf.request.url", (Object)requestURL);
        String contextPath = req.getContextPath();
        if (contextPath == null) {
            contextPath = "";
        }
        if ((servletPath = req.getServletPath()) == null) {
            servletPath = "";
        }
        String contextServletPath = contextPath + servletPath;
        inMessage.put((Object)Message.PATH_INFO, (Object)(contextServletPath + req.getPathInfo()));
        if (!StringUtils.isEmpty((String)requestURI)) {
            index = requestURL.indexOf(requestURI);
            if (index > 0) {
                String schemaInfo = requestURL.substring(0, index);
                String basePathWithContextOnly = schemaInfo + contextPath;
                inMessage.put((Object)HTTP_BASE_PATH, (Object)basePathWithContextOnly);
            }
        } else if (!StringUtils.isEmpty((String)servletPath) && requestURL.endsWith(servletPath) && (index = requestURL.lastIndexOf(servletPath)) > 0) {
            inMessage.put((Object)HTTP_BASE_PATH, (Object)requestURL.substring(0, index));
        }
        String contentType = req.getContentType();
        inMessage.put((Object)"Content-Type", (Object)contentType);
        this.setEncoding(inMessage, req, contentType);
        inMessage.put((Object)Message.QUERY_STRING, (Object)req.getQueryString());
        inMessage.put((Object)"Accept", (Object)req.getHeader("Accept"));
        String basePath = this.getBasePath(contextServletPath);
        if (!StringUtils.isEmpty((String)basePath)) {
            inMessage.put((Object)Message.BASE_PATH, (Object)basePath);
        }
        inMessage.put((Object)Message.FIXED_PARAMETER_ORDER, (Object)this.isFixedParameterOrder());
        inMessage.put((Object)"org.apache.cxf.async.post.response.dispatch", (Object)Boolean.TRUE);
        final Principal pp = req.getUserPrincipal();
        inMessage.put(SecurityContext.class, (Object)new SecurityContext(){

            public Principal getUserPrincipal() {
                return pp;
            }

            public boolean isUserInRole(String role) {
                return req.isUserInRole(role);
            }
        });
        Headers headers = new Headers(inMessage);
        headers.copyFromRequest(req);
        String credentials = headers.getAuthorization();
        AuthorizationPolicy authPolicy = this.getAuthorizationPolicyFromMessage(credentials, pp);
        inMessage.put(AuthorizationPolicy.class, (Object)authPolicy);
        AbstractHTTPDestination.propogateSecureSession(req, inMessage);
        inMessage.put((Object)CertConstraints.class.getName(), (Object)this.certConstraints);
        inMessage.put((Object)Message.IN_INTERCEPTORS, Arrays.asList(new Interceptor[]{CertConstraintsInterceptor.INSTANCE}));
    }

    private static void propogateSecureSession(HttpServletRequest request, Message message) {
        String cipherSuite = (String)request.getAttribute(SSL_CIPHER_SUITE_ATTRIBUTE);
        if (cipherSuite != null) {
            Certificate[] certs = (Certificate[])request.getAttribute(SSL_PEER_CERT_CHAIN_ATTRIBUTE);
            message.put(TLSSessionInfo.class, (Object)new TLSSessionInfo(cipherSuite, null, certs));
        }
    }

    private String setEncoding(Message inMessage, HttpServletRequest req, String contentType) throws IOException {
        String enc = HttpHeaderHelper.findCharset((String)contentType);
        if (enc == null) {
            enc = req.getCharacterEncoding();
        }
        if (enc != null && enc.endsWith("\"")) {
            enc = enc.substring(0, enc.length() - 1);
        }
        if (enc != null || "POST".equals(req.getMethod()) || "PUT".equals(req.getMethod())) {
            String normalizedEncoding = HttpHeaderHelper.mapCharset((String)enc);
            if (normalizedEncoding == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, new Object[]{enc}).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put((Object)Message.ENCODING, (Object)normalizedEncoding);
        }
        return contentType;
    }

    protected Message retrieveFromContinuation(HttpServletRequest req) {
        if (!this.isServlet3) {
            if (this.cproviderFactory != null) {
                return this.cproviderFactory.retrieveFromContinuation(req);
            }
            return null;
        }
        return this.retrieveFromServlet3Async(req);
    }

    protected Message retrieveFromServlet3Async(HttpServletRequest req) {
        try {
            return (Message)req.getAttribute(CXF_CONTINUATION_MESSAGE);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void setupContinuation(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
        try {
            ContinuationProvider p;
            if (this.isServlet3 && req.isAsyncSupported()) {
                inMessage.put((Object)ContinuationProvider.class.getName(), (Object)new Servlet3ContinuationProvider(req, resp, inMessage));
            } else if (this.cproviderFactory != null && (p = this.cproviderFactory.createContinuationProvider(inMessage, req, resp)) != null) {
                inMessage.put((Object)ContinuationProvider.class.getName(), (Object)p);
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    protected String getBasePath(String contextPath) throws IOException {
        if (StringUtils.isEmpty((String)this.endpointInfo.getAddress())) {
            return "";
        }
        return new URL(this.endpointInfo.getAddress()).getPath();
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei) {
        return AbstractHTTPDestination.getAddressValue(ei, true);
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei, boolean dp) {
        if (dp) {
            String addr;
            String eiAddress = ei.getAddress();
            if (eiAddress == null) {
                try {
                    ServerSocket s = new ServerSocket(0);
                    ei.setAddress("http://localhost:" + s.getLocalPort());
                    s.close();
                    return ei;
                }
                catch (IOException ex) {
                    ei.setAddress("http://localhost");
                }
            }
            if ((addr = StringUtils.addDefaultPortIfMissing((String)ei.getAddress())) != null) {
                ei.setAddress(addr);
            }
        }
        return ei;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        HttpServletResponse response = (HttpServletResponse)inMessage.get((Object)HTTP_RESPONSE);
        return new BackChannelConduit(response);
    }

    private void initConfig() {
        PolicyDataEngine pde = (PolicyDataEngine)this.bus.getExtension(PolicyDataEngine.class);
        if (pde != null) {
            this.server = (HTTPServerPolicy)((Object)pde.getServerEndpointPolicy(this.endpointInfo, (Destination)this, (PolicyCalculator)new ServerPolicyCalculator()));
        }
        if (null == this.server && WSDLLibrary.isAvailable()) {
            this.server = (HTTPServerPolicy)((Object)this.endpointInfo.getTraversedExtensor((Object)new HTTPServerPolicy(), HTTPServerPolicy.class));
        }
        this.cproviderFactory = (ContinuationProviderFactory)this.bus.getExtension(ContinuationProviderFactory.class);
    }

    private void cacheInput(Message outMessage) {
        DelegatingInputStream in;
        if (outMessage.getExchange() == null) {
            return;
        }
        Message inMessage = outMessage.getExchange().getInMessage();
        if (inMessage == null) {
            return;
        }
        Collection atts = inMessage.getAttachments();
        if (atts != null) {
            for (Attachment a : atts) {
                if (!(a.getDataHandler().getDataSource() instanceof AttachmentDataSource)) continue;
                try {
                    ((AttachmentDataSource)a.getDataHandler().getDataSource()).cache(inMessage);
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
            }
        }
        if ((in = (DelegatingInputStream)inMessage.getContent(DelegatingInputStream.class)) != null) {
            in.cacheInput();
        }
    }

    protected OutputStream flushHeaders(Message outMessage) throws IOException {
        return this.flushHeaders(outMessage, true);
    }

    protected OutputStream flushHeaders(Message outMessage, boolean getStream) throws IOException {
        if (this.isResponseRedirected(outMessage)) {
            return null;
        }
        this.cacheInput(outMessage);
        if (this.server != null) {
            new Headers(outMessage).setFromServerPolicy(this.server);
        }
        ServletOutputStream responseStream = null;
        boolean oneWay = this.isOneWay(outMessage);
        HttpServletResponse response = this.getHttpResponseFromMessage(outMessage);
        int responseCode = this.getReponseCodeFromMessage(outMessage);
        response.setStatus(responseCode);
        if (500 == responseCode) {
            new Headers(outMessage).removeContentType();
        }
        new Headers(outMessage).copyToResponse(response);
        outMessage.put((Object)RESPONSE_HEADERS_COPIED, (Object)"true");
        if (this.hasNoResponseContent(outMessage)) {
            response.setContentLength(0);
            response.flushBuffer();
            response.getOutputStream().close();
        } else if (!getStream) {
            response.getOutputStream().close();
        } else {
            responseStream = response.getOutputStream();
        }
        if (oneWay) {
            outMessage.remove((Object)HTTP_RESPONSE);
        }
        return responseStream;
    }

    private int getReponseCodeFromMessage(Message message) {
        Integer i = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (i != null) {
            return i;
        }
        if (this.hasNoResponseContent(message)) {
            return 202;
        }
        return 200;
    }

    private boolean hasNoResponseContent(Message message) {
        boolean ow = this.isOneWay(message);
        boolean pr = MessageUtils.isPartialResponse((Message)message);
        boolean epr = MessageUtils.isEmptyPartialResponse((Message)message);
        return ow && (!pr || epr) || !ow && epr;
    }

    private HttpServletResponse getHttpResponseFromMessage(Message message) throws IOException {
        Object responseObj = message.get((Object)HTTP_RESPONSE);
        if (responseObj instanceof HttpServletResponse) {
            return (HttpServletResponse)responseObj;
        }
        if (null != responseObj) {
            String m = new org.apache.cxf.common.i18n.Message("UNEXPECTED_RESPONSE_TYPE_MSG", LOG, new Object[]{responseObj.getClass()}).toString();
            LOG.log(Level.WARNING, m);
            throw new IOException(m);
        }
        String m = new org.apache.cxf.common.i18n.Message("NULL_RESPONSE_MSG", LOG, new Object[0]).toString();
        LOG.log(Level.WARNING, m);
        throw new IOException(m);
    }

    private boolean isResponseRedirected(Message outMessage) {
        return Boolean.TRUE.equals(outMessage.get((Object)REQUEST_REDIRECTED));
    }

    protected boolean contextMatchOnExact() {
        return "exact".equals(this.contextMatchStrategy);
    }

    public void finalizeConfig() {
    }

    public String getBeanName() {
        String beanName = null;
        if (this.endpointInfo.getName() != null) {
            beanName = this.endpointInfo.getName().toString() + ".http-destination";
        }
        return beanName;
    }

    public EndpointReferenceType getAddressWithId(String id) {
        EndpointReferenceType ref = null;
        if (this.isMultiplexWithAddress()) {
            String address = EndpointReferenceUtils.getAddress((EndpointReferenceType)this.reference);
            ref = EndpointReferenceUtils.duplicate((EndpointReferenceType)this.reference);
            if (address.endsWith("/")) {
                EndpointReferenceUtils.setAddress((EndpointReferenceType)ref, (String)(address + id));
            } else {
                EndpointReferenceUtils.setAddress((EndpointReferenceType)ref, (String)(address + "/" + id));
            }
        } else {
            ref = super.getAddressWithId(id);
        }
        return ref;
    }

    public String getId(Map<String, Object> context) {
        String id = null;
        if (this.isMultiplexWithAddress()) {
            String address = (String)context.get(Message.PATH_INFO);
            if (null != address) {
                int afterLastSlashIndex = address.lastIndexOf("/") + 1;
                if (afterLastSlashIndex > 0 && afterLastSlashIndex < address.length()) {
                    id = address.substring(afterLastSlashIndex);
                }
            } else {
                this.getLogger().log(Level.WARNING, new org.apache.cxf.common.i18n.Message("MISSING_PATH_INFO", LOG, new Object[0]).toString());
            }
        } else {
            return super.getId(context);
        }
        return id;
    }

    public String getContextMatchStrategy() {
        return this.contextMatchStrategy;
    }

    public void setContextMatchStrategy(String contextMatchStrategy) {
        this.contextMatchStrategy = contextMatchStrategy;
    }

    public boolean isFixedParameterOrder() {
        return this.fixedParameterOrder;
    }

    public void setFixedParameterOrder(boolean fixedParameterOrder) {
        this.fixedParameterOrder = fixedParameterOrder;
    }

    public boolean isMultiplexWithAddress() {
        return this.multiplexWithAddress;
    }

    public void setMultiplexWithAddress(boolean multiplexWithAddress) {
        this.multiplexWithAddress = multiplexWithAddress;
    }

    public HTTPServerPolicy getServer() {
        return this.server;
    }

    public void setServer(HTTPServerPolicy server) {
        this.server = server;
    }

    public void assertMessage(Message message) {
        PolicyDataEngine pde = (PolicyDataEngine)this.bus.getExtension(PolicyDataEngine.class);
        pde.assertMessage(message, (Object)this.server, (PolicyCalculator)new ServerPolicyCalculator());
    }

    public boolean canAssert(QName type) {
        return new ServerPolicyCalculator().getDataClassName().equals(type);
    }

    public void releaseRegistry() {
        this.registry = null;
    }

    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate() {
        AbstractHTTPDestination abstractHTTPDestination = this;
        synchronized (abstractHTTPDestination) {
            if (this.registry != null) {
                this.registry.addDestination(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        AbstractHTTPDestination abstractHTTPDestination = this;
        synchronized (abstractHTTPDestination) {
            if (this.registry != null) {
                this.registry.removeDestination(this.path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AbstractHTTPDestination abstractHTTPDestination = this;
        synchronized (abstractHTTPDestination) {
            if (this.registry != null) {
                this.registry.removeDestination(this.path);
            }
        }
        super.shutdown();
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        protected HttpServletResponse response;
        private Message outMessage;

        WrappedOutputStream(Message m, HttpServletResponse resp) {
            this.outMessage = m;
            this.response = resp;
        }

        protected void onFirstWrite() throws IOException {
            OutputStream responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage);
            if (null != responseStream) {
                this.wrappedStream = responseStream;
            }
        }

        public void close() throws IOException {
            OutputStream responseStream;
            if (!this.written && this.wrappedStream == null && null != (responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage, false))) {
                this.wrappedStream = responseStream;
            }
            if (this.wrappedStream != null) {
                this.wrappedStream.close();
                this.response.flushBuffer();
            }
        }
    }

    public class BackChannelConduit
    extends AbstractDestination.AbstractBackChannelConduit {
        protected HttpServletResponse response;

        BackChannelConduit(HttpServletResponse resp) {
            super((AbstractDestination)AbstractHTTPDestination.this);
            this.response = resp;
        }

        public void prepare(Message message) throws IOException {
            message.put((Object)AbstractHTTPDestination.HTTP_RESPONSE, (Object)this.response);
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            if (os == null) {
                message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message, this.response));
            }
        }

        public void close(Message msg) throws IOException {
            super.close(msg);
            if (msg.getExchange() == null) {
                return;
            }
            Message m = msg.getExchange().getInMessage();
            if (m == null) {
                return;
            }
            InputStream is = (InputStream)m.getContent(InputStream.class);
            if (is != null) {
                try {
                    is.close();
                    m.removeContent(InputStream.class);
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
        }
    }

    public static final class PrincipalAuthorizationPolicy
    extends AuthorizationPolicy {
        final Principal principal;

        public PrincipalAuthorizationPolicy(Principal p) {
            this.principal = p;
        }

        public Principal getPrincipal() {
            return this.principal;
        }
    }
}

