/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.msc;

import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.msc.BatchServiceTargetFactory;
import org.jboss.as.clustering.msc.DelegatingServiceTarget;
import org.jboss.as.clustering.msc.ServiceBuilderFactory;
import org.jboss.as.clustering.msc.ServiceControllerFactory;
import org.jboss.as.clustering.msc.ServiceTargetFactory;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class DelegatingServiceContainer
extends DelegatingServiceTarget
implements ServiceContainer {
    private final ServiceContainer container;
    private final ServiceControllerFactory controllerFactory;

    public DelegatingServiceContainer(ServiceContainer container, ServiceTargetFactory factory, BatchServiceTargetFactory batchFactory, ServiceBuilderFactory builderFactory, ServiceControllerFactory controllerFactory) {
        super((ServiceTarget)container, factory, batchFactory, builderFactory);
        this.container = container;
        this.controllerFactory = controllerFactory;
    }

    public ServiceController<?> getRequiredService(ServiceName serviceName) {
        return this.controllerFactory.createServiceController(this.container.getRequiredService(serviceName));
    }

    public ServiceController<?> getService(ServiceName serviceName) {
        return this.controllerFactory.createServiceController(this.container.getService(serviceName));
    }

    public List<ServiceName> getServiceNames() {
        return this.container.getServiceNames();
    }

    public void shutdown() {
        this.container.shutdown();
    }

    public boolean isShutdownComplete() {
        return this.container.isShutdownComplete();
    }

    public void addTerminateListener(ServiceContainer.TerminateListener listener) {
        this.container.addTerminateListener(listener);
    }

    public void awaitTermination() throws InterruptedException {
        this.container.awaitTermination();
    }

    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.container.awaitTermination(timeout, unit);
    }

    public void dumpServices() {
        this.container.dumpServices();
    }

    public void dumpServices(PrintStream stream) {
        this.container.dumpServices(stream);
    }

    public String getName() {
        return this.container.getName();
    }
}

