/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.util.Map;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.wstrust.ClaimsProcessor;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestHandler;

public class WSTrustServiceFactory {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final WSTrustServiceFactory factory = new WSTrustServiceFactory();

    private WSTrustServiceFactory() {
    }

    public static WSTrustServiceFactory getInstance() {
        return factory;
    }

    public WSTrustRequestHandler createRequestHandler(String handlerClassName, STSConfiguration configuration) {
        try {
            Class<?> clazz = SecurityActions.loadClass(this.getClass(), handlerClassName);
            if (clazz == null) {
                throw logger.classNotLoadedError(handlerClassName);
            }
            WSTrustRequestHandler handler = (WSTrustRequestHandler)clazz.newInstance();
            handler.initialize(configuration);
            return handler;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public SecurityTokenProvider createTokenProvider(String providerClass, Map<String, String> properties) {
        try {
            Class<?> clazz = SecurityActions.loadClass(this.getClass(), providerClass);
            if (clazz == null) {
                throw logger.classNotLoadedError(providerClass);
            }
            SecurityTokenProvider tokenProvider = (SecurityTokenProvider)clazz.newInstance();
            tokenProvider.initialize(properties);
            return tokenProvider;
        }
        catch (Exception pae) {
            throw new RuntimeException(logger.couldNotCreateInstance(providerClass, pae));
        }
    }

    public ClaimsProcessor createClaimsProcessor(String processorClass, Map<String, String> properties) {
        try {
            Class<?> clazz = SecurityActions.loadClass(this.getClass(), processorClass);
            if (clazz == null) {
                throw logger.classNotLoadedError(processorClass);
            }
            ClaimsProcessor claimsProcessor = (ClaimsProcessor)clazz.newInstance();
            claimsProcessor.initialize(properties);
            return claimsProcessor;
        }
        catch (Exception pae) {
            throw new RuntimeException(logger.couldNotCreateInstance("claims processor " + processorClass, pae));
        }
    }
}

