/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.InputStream;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.config.SecurityActions;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public class SPPostMetadataConfigurationProvider
extends AbstractSAMLConfigurationProvider
implements SAMLConfigurationProvider {
    public static final String SP_MD_FILE = "sp-metadata.xml";
    public static final String bindingURI = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();

    @Override
    public IDPType getIDPConfiguration() throws ProcessingException {
        throw new RuntimeException("PL00020: Illegal Method Called");
    }

    @Override
    public SPType getSPConfiguration() throws ProcessingException {
        SPType spType = null;
        if (this.fileAvailable()) {
            try {
                EntitiesDescriptorType entities = this.parseMDFile();
                spType = CoreConfigUtil.getSPConfiguration(entities, bindingURI);
            }
            catch (ParsingException e) {
                throw logger.processingError(e);
            }
            catch (ConfigurationException e) {
                throw logger.processingError(e);
            }
        } else {
            throw logger.nullValueError(SP_MD_FILE);
        }
        if (this.configParsedSPType != null) {
            spType.importFrom(this.configParsedSPType);
        }
        return spType;
    }

    private boolean fileAvailable() {
        InputStream is = SecurityActions.loadStream(this.getClass(), SP_MD_FILE);
        return is != null;
    }

    private EntitiesDescriptorType parseMDFile() throws ParsingException {
        InputStream is = SecurityActions.loadStream(this.getClass(), SP_MD_FILE);
        if (is == null) {
            throw logger.nullValueError(SP_MD_FILE);
        }
        SAMLParser parser = new SAMLParser();
        return (EntitiesDescriptorType)parser.parse(is);
    }
}

