/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.ServerSecurityManager;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SSLIdentity;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.ClientCertCallbackHandler;
import org.jboss.as.domain.management.security.FileKeystoreService;
import org.jboss.as.domain.management.security.JaasAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.JaasCallbackHandler;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.LdapAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LocalAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LocalCallbackHandlerService;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.PlugInAuthenticationCallbackHandler;
import org.jboss.as.domain.management.security.PlugInAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInLoaderService;
import org.jboss.as.domain.management.security.PlugInSubjectSupplemental;
import org.jboss.as.domain.management.security.PropertiesAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesCallbackHandler;
import org.jboss.as.domain.management.security.PropertiesSubjectSupplemental;
import org.jboss.as.domain.management.security.PropertyResourceDefinition;
import org.jboss.as.domain.management.security.SSLIdentityService;
import org.jboss.as.domain.management.security.SSLServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecretIdentityService;
import org.jboss.as.domain.management.security.SecretServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.as.domain.management.security.UserDomainCallbackHandler;
import org.jboss.as.domain.management.security.UserLdapCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class SecurityRealmAddHandler
implements OperationStepHandler {
    public static final SecurityRealmAddHandler INSTANCE = new SecurityRealmAddHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode validationOp = AuthenticationValidatingHandler.createOperation(operation);
        context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addStep((OperationStepHandler)ServiceInstallStepHandler.INSTANCE, OperationContext.Stage.RUNTIME);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void installServices(OperationContext context, String realmName, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode plugIns = model.hasDefined("plug-in") ? model.get("plug-in") : null;
        ModelNode authentication = model.hasDefined("authentication") ? model.get("authentication") : null;
        ModelNode authorization = model.hasDefined("authorization") ? model.get("authorization") : null;
        ModelNode serverIdentities = model.hasDefined("server-identity") ? model.get("server-identity") : null;
        ServiceTarget serviceTarget = context.getServiceTarget();
        SecurityRealmService securityRealmService = new SecurityRealmService(realmName);
        ServiceName realmServiceName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmName});
        ServiceBuilder realmBuilder = serviceTarget.addService(realmServiceName, (Service)securityRealmService);
        ServiceName plugInLoaderName = null;
        ServiceName authenticationName = null;
        ServiceName authorizationName = null;
        ModelNode authTruststore = null;
        if (plugIns != null) {
            plugInLoaderName = this.addPlugInLoaderService(realmServiceName, plugIns, serviceTarget, newControllers);
        }
        if (authentication != null) {
            if (authentication.hasDefined("truststore")) {
                authTruststore = authentication.require("truststore");
                ServiceName ccName = this.addClientCertService(realmServiceName, serviceTarget, newControllers);
                realmBuilder.addDependency(ccName, CallbackHandlerService.class, securityRealmService.getCallbackHandlerService().injector());
            }
            if (authentication.hasDefined("local")) {
                ServiceName localName = this.addLocalService(context, authentication.require("local"), realmServiceName, serviceTarget, newControllers);
                realmBuilder.addDependency(localName, CallbackHandlerService.class, securityRealmService.getCallbackHandlerService().injector());
            }
            if (authentication.hasDefined("jaas")) {
                authenticationName = this.addJaasService(context, authentication.require("jaas"), realmServiceName, serviceTarget, newControllers, context.isNormalServer());
            } else if (authentication.hasDefined("ldap")) {
                authenticationName = this.addLdapService(context, authentication.require("ldap"), realmServiceName, serviceTarget, newControllers);
            } else if (authentication.hasDefined("plug-in")) {
                authenticationName = this.addPlugInAuthenticationService(context, authentication.require("plug-in"), realmServiceName, plugInLoaderName, securityRealmService, serviceTarget, newControllers);
            } else if (authentication.hasDefined("properties")) {
                authenticationName = this.addPropertiesAuthenticationService(context, authentication.require("properties"), realmServiceName, realmName, serviceTarget, newControllers);
            } else if (authentication.hasDefined("users")) {
                authenticationName = this.addUsersService(context, authentication.require("users"), realmServiceName, realmName, serviceTarget, newControllers);
            }
        }
        if (authorization != null) {
            if (authorization.hasDefined("properties")) {
                authorizationName = this.addPropertiesAuthorizationService(context, authorization.require("properties"), realmServiceName, serviceTarget, newControllers);
            } else if (authorization.hasDefined("plug-in")) {
                authorizationName = this.addPlugInAuthorizationService(context, authorization.require("plug-in"), realmServiceName, plugInLoaderName, realmName, serviceTarget, newControllers);
            }
        }
        if (authenticationName != null) {
            realmBuilder.addDependency(authenticationName, CallbackHandlerService.class, securityRealmService.getCallbackHandlerService().injector());
        }
        if (authorizationName != null) {
            realmBuilder.addDependency(authorizationName, SubjectSupplementalService.class, securityRealmService.getSubjectSupplementalInjector());
        }
        ModelNode ssl = null;
        if (serverIdentities != null) {
            if (serverIdentities.hasDefined("ssl")) {
                ssl = serverIdentities.require("ssl");
            }
            if (serverIdentities.hasDefined("secret")) {
                ServiceName secretServiceName = this.addSecretService(context, serverIdentities.require("secret"), realmServiceName, serviceTarget, newControllers);
                realmBuilder.addDependency(secretServiceName, CallbackHandlerFactory.class, securityRealmService.getSecretCallbackFactory());
            }
        }
        if (ssl != null || authTruststore != null) {
            ServiceName sslServiceName = this.addSSLService(context, ssl, authTruststore, realmServiceName, serviceTarget, newControllers);
            realmBuilder.addDependency(sslServiceName, SSLIdentity.class, securityRealmService.getSSLIdentityInjector());
        }
        realmBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController sc = realmBuilder.install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
    }

    private ServiceName addPlugInLoaderService(ServiceName realmServiceName, ModelNode plugInModel, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName plugInLoaderName = realmServiceName.append(new String[]{"plug-in-loader"});
        List plugIns = plugInModel.asPropertyList();
        ArrayList<String> knownNames = new ArrayList<String>(plugIns.size());
        for (Property current : plugIns) {
            knownNames.add(current.getName());
        }
        PlugInLoaderService loaderService = new PlugInLoaderService(Collections.unmodifiableList(knownNames));
        ServiceBuilder builder = serviceTarget.addService(plugInLoaderName, (Service)loaderService);
        ServiceController sc = builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
        return plugInLoaderName;
    }

    private ServiceName addClientCertService(ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName clientCertServiceName = realmServiceName.append(new String[]{"client_cert"});
        ClientCertCallbackHandler clientCertCallbackHandler = new ClientCertCallbackHandler();
        ServiceBuilder ccBuilder = serviceTarget.addService(clientCertServiceName, (Service)clientCertCallbackHandler);
        ServiceController sc = ccBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
        return clientCertServiceName;
    }

    private ServiceName addJaasService(OperationContext context, ModelNode jaas, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, boolean injectServerManager) throws OperationFailedException {
        ServiceName jaasServiceName = realmServiceName.append(new String[]{"jaas"});
        String name = JaasAuthenticationResourceDefinition.NAME.resolveModelAttribute(context, jaas).asString();
        JaasCallbackHandler jaasCallbackHandler = new JaasCallbackHandler(name);
        ServiceBuilder jaasBuilder = serviceTarget.addService(jaasServiceName, (Service)jaasCallbackHandler);
        if (injectServerManager) {
            jaasBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"security", "simple-security-manager"}), ServerSecurityManager.class, jaasCallbackHandler.getSecurityManagerValue());
        }
        ServiceController sc = jaasBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
        return jaasServiceName;
    }

    private ServiceName addLdapService(OperationContext context, ModelNode ldap, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName ldapServiceName = realmServiceName.append(new String[]{"ldap"});
        String baseDn = LdapAuthenticationResourceDefinition.BASE_DN.resolveModelAttribute(context, ldap).asString();
        ModelNode node = LdapAuthenticationResourceDefinition.USERNAME_FILTER.resolveModelAttribute(context, ldap);
        String usernameAttribute = node.isDefined() ? node.asString() : null;
        node = LdapAuthenticationResourceDefinition.ADVANCED_FILTER.resolveModelAttribute(context, ldap);
        String advancedFilter = node.isDefined() ? node.asString() : null;
        boolean recursive = LdapAuthenticationResourceDefinition.RECURSIVE.resolveModelAttribute(context, ldap).asBoolean();
        boolean allowEmptyPasswords = LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.resolveModelAttribute(context, ldap).asBoolean();
        String userDn = LdapAuthenticationResourceDefinition.USER_DN.resolveModelAttribute(context, ldap).asString();
        UserLdapCallbackHandler ldapCallbackHandler = new UserLdapCallbackHandler(baseDn, usernameAttribute, advancedFilter, recursive, userDn, allowEmptyPasswords);
        ServiceBuilder ldapBuilder = serviceTarget.addService(ldapServiceName, (Service)ldapCallbackHandler);
        String connectionManager = LdapAuthenticationResourceDefinition.CONNECTION.resolveModelAttribute(context, ldap).asString();
        ldapBuilder.addDependency(LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{connectionManager}), ConnectionManager.class, ldapCallbackHandler.getConnectionManagerInjector());
        ServiceController serviceController = ldapBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return ldapServiceName;
    }

    private ServiceName addLocalService(OperationContext context, ModelNode local, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName localServiceName = realmServiceName.append(new String[]{"local"});
        ModelNode node = LocalAuthenticationResourceDefinition.DEFAULT_USER.resolveModelAttribute(context, local);
        String defaultUser = node.isDefined() ? node.asString() : null;
        node = LocalAuthenticationResourceDefinition.ALLOWED_USERS.resolveModelAttribute(context, local);
        String allowedUsers = node.isDefined() ? node.asString() : null;
        LocalCallbackHandlerService localCallbackHandler = new LocalCallbackHandlerService(defaultUser, allowedUsers);
        ServiceBuilder jaasBuilder = serviceTarget.addService(localServiceName, (Service)localCallbackHandler);
        ServiceController serviceController = jaasBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return localServiceName;
    }

    private ServiceName addPlugInAuthenticationService(OperationContext context, ModelNode model, ServiceName realmServiceName, ServiceName plugInLoaderName, SecurityRealmService registry, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName plugInServiceName = realmServiceName.append(new String[]{"plug-in-authentication"});
        String pluginName = PlugInAuthorizationResourceDefinition.NAME.resolveModelAttribute(context, model).asString();
        Map<String, String> properties = SecurityRealmAddHandler.resolveProperties(context, model);
        String mechanismName = PlugInAuthenticationResourceDefinition.MECHANISM.resolveModelAttribute(context, model).asString();
        AuthenticationMechanism mechanism = AuthenticationMechanism.valueOf(mechanismName);
        PlugInAuthenticationCallbackHandler plugInService = new PlugInAuthenticationCallbackHandler(registry.getName(), pluginName, properties, mechanism);
        ServiceBuilder plugInBuilder = serviceTarget.addService(plugInServiceName, (Service)plugInService);
        plugInBuilder.addDependency(plugInLoaderName, PlugInLoaderService.class, (Injector)plugInService.getPlugInLoaderServiceValue());
        ServiceController sc = plugInBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
        return plugInServiceName;
    }

    private ServiceName addPropertiesAuthenticationService(OperationContext context, ModelNode properties, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName propsServiceName = realmServiceName.append(new String[]{"properties_authentication"});
        String path = PropertiesAuthenticationResourceDefinition.PATH.resolveModelAttribute(context, properties).asString();
        ModelNode relativeTo = PropertiesAuthenticationResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, properties);
        boolean plainText = PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.resolveModelAttribute(context, properties).asBoolean();
        PropertiesCallbackHandler propsCallbackHandler = new PropertiesCallbackHandler(realmName, path, plainText);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsCallbackHandler);
        if (relativeTo.isDefined()) {
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo.asString()), String.class, propsCallbackHandler.getRelativeToInjector());
        }
        ServiceController serviceController = propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return propsServiceName;
    }

    private ServiceName addPropertiesAuthorizationService(OperationContext context, ModelNode properties, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName propsServiceName = realmServiceName.append(new String[]{"properties_authorization"});
        String path = PropertiesAuthorizationResourceDefinition.PATH.resolveModelAttribute(context, properties).asString();
        ModelNode relativeTo = PropertiesAuthorizationResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, properties);
        PropertiesSubjectSupplemental propsSubjectSupplemental = new PropertiesSubjectSupplemental(path);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsSubjectSupplemental);
        if (relativeTo.isDefined()) {
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo.asString()), String.class, propsSubjectSupplemental.getRelativeToInjector());
        }
        ServiceController serviceController = propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return propsServiceName;
    }

    private ServiceName addPlugInAuthorizationService(OperationContext context, ModelNode model, ServiceName realmServiceName, ServiceName plugInLoaderName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName plugInServiceName = realmServiceName.append(new String[]{"plug-in-authorization"});
        String pluginName = PlugInAuthorizationResourceDefinition.NAME.resolveModelAttribute(context, model).asString();
        Map<String, String> properties = SecurityRealmAddHandler.resolveProperties(context, model);
        PlugInSubjectSupplemental plugInSubjectSupplemental = new PlugInSubjectSupplemental(realmName, pluginName, properties);
        ServiceBuilder plugInBuilder = serviceTarget.addService(plugInServiceName, (Service)plugInSubjectSupplemental);
        plugInBuilder.addDependency(plugInLoaderName, PlugInLoaderService.class, (Injector)plugInSubjectSupplemental.getPlugInLoaderServiceValue());
        ServiceController serviceController = plugInBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return plugInServiceName;
    }

    private ServiceName addSSLService(OperationContext context, ModelNode ssl, ModelNode trustStore, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ssl = ssl == null ? new ModelNode() : ssl;
        ServiceName sslServiceName = realmServiceName.append(new String[]{"ssl"});
        ServiceName keystoreServiceName = null;
        KeyPair pair = null;
        if (ssl.hasDefined("keystore-path")) {
            keystoreServiceName = realmServiceName.append(new String[]{"keystore"});
            pair = this.addFileKeystoreService(context, ssl, keystoreServiceName, serviceTarget, newControllers);
        }
        ServiceName truststoreServiceName = null;
        if (trustStore != null) {
            truststoreServiceName = realmServiceName.append(new String[]{"truststore"});
            this.addFileKeystoreService(context, trustStore, truststoreServiceName, serviceTarget, newControllers);
        }
        String protocol = SSLServerIdentityResourceDefinition.PROTOCOL.resolveModelAttribute(context, ssl).asString();
        SSLIdentityService sslIdentityService = new SSLIdentityService(protocol, pair == null ? null : pair.keystorePassword, pair == null ? null : pair.keyPassword);
        ServiceBuilder sslBuilder = serviceTarget.addService(sslServiceName, (Service)sslIdentityService);
        if (keystoreServiceName != null) {
            sslBuilder.addDependency(keystoreServiceName, KeyStore.class, sslIdentityService.getKeyStoreInjector());
        }
        if (truststoreServiceName != null) {
            sslBuilder.addDependency(truststoreServiceName, KeyStore.class, sslIdentityService.getTrustStoreInjector());
        }
        ServiceController serviceController = sslBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return sslServiceName;
    }

    private KeyPair addFileKeystoreService(OperationContext context, ModelNode ssl, ServiceName serviceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        char[] keystorePassword = KeystoreAttributes.KEYSTORE_PASSWORD.resolveModelAttribute(context, ssl).asString().toCharArray();
        char[] keyPassword = null;
        ModelNode pwordNode = KeystoreAttributes.KEY_PASSWORD.resolveModelAttribute(context, ssl);
        if (pwordNode.isDefined()) {
            keyPassword = pwordNode.asString().toCharArray();
        }
        String path = KeystoreAttributes.KEYSTORE_PATH.resolveModelAttribute(context, ssl).asString();
        ModelNode aliasNode = KeystoreAttributes.ALIAS.resolveModelAttribute(context, ssl);
        String alias = aliasNode.isDefined() ? aliasNode.asString() : null;
        FileKeystoreService fileKeystoreService = new FileKeystoreService(path, keystorePassword, alias, keyPassword);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)fileKeystoreService);
        ModelNode relativeTo = KeystoreAttributes.KEYSTORE_RELATIVE_TO.resolveModelAttribute(context, ssl);
        if (relativeTo.isDefined()) {
            serviceBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo.asString()), String.class, fileKeystoreService.getRelativeToInjector());
        }
        ServiceController serviceController = serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        KeyPair pair = new KeyPair();
        KeyPair.access$102(pair, keystorePassword);
        KeyPair.access$202(pair, keyPassword);
        return pair;
    }

    private ServiceName addSecretService(OperationContext context, ModelNode secret, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName secretServiceName = realmServiceName.append(new String[]{"secret"});
        ModelNode resolvedValueNode = SecretServerIdentityResourceDefinition.VALUE.resolveModelAttribute(context, secret);
        boolean base64 = secret.get(SecretServerIdentityResourceDefinition.VALUE.getName()).getType() != ModelType.EXPRESSION;
        SecretIdentityService sis = new SecretIdentityService(resolvedValueNode.asString(), base64);
        ServiceController serviceController = serviceTarget.addService(secretServiceName, (Service)sis).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return secretServiceName;
    }

    private ServiceName addUsersService(OperationContext context, ModelNode users, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName usersServiceName = realmServiceName.append(new String[]{"users"});
        UserDomainCallbackHandler usersCallbackHandler = new UserDomainCallbackHandler(realmName, this.unmaskUsersPasswords(context, users));
        ServiceBuilder usersBuilder = serviceTarget.addService(usersServiceName, (Service)usersCallbackHandler);
        ServiceController serviceController = usersBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return usersServiceName;
    }

    private static ServiceName pathName(String relativeTo) {
        return ServiceName.JBOSS.append(new String[]{"server", "path", relativeTo});
    }

    private ModelNode unmaskUsersPasswords(OperationContext context, ModelNode users) throws OperationFailedException {
        users = users.clone();
        for (Property property : users.get("user").asPropertyList()) {
            ModelNode user = users.get(new String[]{"user", property.getName()});
            if (!user.hasDefined("password")) continue;
            user.set("password", context.resolveExpressions(user.get("password")).asString());
        }
        return users;
    }

    private static Map<String, String> resolveProperties(OperationContext context, ModelNode model) throws OperationFailedException {
        Map<String, String> configurationProperties;
        if (model.hasDefined("property")) {
            List propertyList = model.require("property").asPropertyList();
            configurationProperties = new HashMap<String, String>(propertyList.size());
            for (Property current : propertyList) {
                String propertyName = current.getName();
                ModelNode valueNode = PropertyResourceDefinition.VALUE.resolveModelAttribute(context, current.getValue());
                String value = valueNode.isDefined() ? valueNode.asString() : null;
                configurationProperties.put(propertyName, value);
            }
            configurationProperties = Collections.unmodifiableMap(configurationProperties);
        } else {
            configurationProperties = Collections.emptyMap();
        }
        return configurationProperties;
    }

    private static class ServiceInstallStepHandler
    implements OperationStepHandler {
        private static final ServiceInstallStepHandler INSTANCE = new ServiceInstallStepHandler();

        private ServiceInstallStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final ArrayList newControllers = new ArrayList();
            String realmName = ManagementUtil.getSecurityRealmName(operation);
            ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            INSTANCE.installServices(context, realmName, model, new ServiceVerificationHandler(), newControllers);
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    for (ServiceController sc : newControllers) {
                        context.removeService(sc);
                    }
                }
            });
        }
    }

    private static class KeyPair {
        private char[] keystorePassword;
        private char[] keyPassword;

        private KeyPair() {
        }

        static /* synthetic */ char[] access$102(KeyPair x0, char[] x1) {
            x0.keystorePassword = x1;
            return x1;
        }

        static /* synthetic */ char[] access$202(KeyPair x0, char[] x1) {
            x0.keyPassword = x1;
            return x1;
        }
    }
}

