/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensaml.common.binding.AbstractEndpointSelector;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IndexedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEndpointSelector
extends AbstractEndpointSelector {
    private Logger log = LoggerFactory.getLogger(BasicEndpointSelector.class);

    @Override
    public Endpoint selectEndpoint() {
        if (this.getEntityRoleMetadata() == null) {
            return null;
        }
        List<Endpoint> endpoints = this.getEntityRoleMetadata().getEndpoints(this.getEndpointType());
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        if ((endpoints = this.filterEndpointsByProtocolBinding(endpoints)) == null || endpoints.size() == 0) {
            return null;
        }
        Endpoint selectedEndpoint = endpoints.get(0) instanceof IndexedEndpoint ? this.selectIndexedEndpoint(endpoints) : this.selectNonIndexedEndpoint(endpoints);
        this.log.debug("Selected endpoint {} for request", (Object)selectedEndpoint.getLocation());
        return selectedEndpoint;
    }

    protected List<? extends Endpoint> filterEndpointsByProtocolBinding(List<? extends Endpoint> endpoints) {
        ArrayList<? extends Endpoint> filteredEndpoints = new ArrayList<Endpoint>(endpoints);
        Iterator endpointItr = filteredEndpoints.iterator();
        while (endpointItr.hasNext()) {
            Endpoint endpoint = (Endpoint)endpointItr.next();
            if (this.getSupportedIssuerBindings().contains(endpoint.getBinding())) continue;
            endpointItr.remove();
        }
        return filteredEndpoints;
    }

    protected Endpoint selectIndexedEndpoint(List<IndexedEndpoint> endpoints) {
        ArrayList<IndexedEndpoint> endpointsCopy = new ArrayList<IndexedEndpoint>(endpoints);
        Iterator endpointItr = endpointsCopy.iterator();
        IndexedEndpoint firstNoDefaultEndpoint = null;
        while (endpointItr.hasNext()) {
            IndexedEndpoint currentEndpoint = (IndexedEndpoint)endpointItr.next();
            if (currentEndpoint.isDefault() == null) continue;
            if (currentEndpoint.isDefault().booleanValue()) {
                return currentEndpoint;
            }
            if (firstNoDefaultEndpoint != null) continue;
            firstNoDefaultEndpoint = currentEndpoint;
        }
        if (firstNoDefaultEndpoint != null) {
            return firstNoDefaultEndpoint;
        }
        if (endpointsCopy.size() > 0) {
            return (Endpoint)endpointsCopy.get(0);
        }
        return null;
    }

    protected Endpoint selectNonIndexedEndpoint(List<Endpoint> endpoints) {
        Iterator<Endpoint> endpointItr = endpoints.iterator();
        if (endpointItr.hasNext()) {
            Endpoint endpoint = endpointItr.next();
            return endpoint;
        }
        return null;
    }
}

