/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.mysql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.jboss.jca.adapters.jdbc.extensions.mysql.SecurityActions;
import org.jboss.jca.adapters.jdbc.spi.reauth.ReauthPlugin;

public class MySQLReauthPlugin
implements ReauthPlugin {
    @Override
    public synchronized void initialize(ClassLoader cl) throws SQLException {
        Class<?> mysqlConnection = null;
        try {
            mysqlConnection = Class.forName("com.mysql.jdbc.Connection", true, cl);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (mysqlConnection == null) {
            try {
                mysqlConnection = Class.forName("com.mysql.jdbc.Connection", true, this.getClass().getClassLoader());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (mysqlConnection == null) {
            try {
                ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
                mysqlConnection = Class.forName("com.mysql.jdbc.Connection", true, tccl);
            }
            catch (Throwable t) {
                throw new SQLException("Cannot resolve com.mysq.jdbc.Connection", t);
            }
        }
        try {
            mysqlConnection.getMethod("changeUser", String.class, String.class);
        }
        catch (Throwable t) {
            throw new SQLException("Cannot resolve com.mysq.jdbc.Connection changeUser method", t);
        }
    }

    @Override
    public synchronized void reauthenticate(Connection c, String userName, String password) throws SQLException {
        Object[] params = new Object[]{userName, password};
        try {
            Method changeUser = c.getClass().getMethod("changeUser", String.class, String.class);
            SecurityActions.setAccessible(changeUser);
            changeUser.invoke((Object)c, params);
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException("Unexpected error in changeUser", t);
        }
    }
}

