/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.util.Collection;
import java.util.HashMap;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCMappingMetaData;

public final class JDBCTypeMappingMetaData {
    private static final String[] PRIMITIVES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final String[] PRIMITIVE_CLASSES = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    public static final String CONCAT = "concat";
    public static final String SUBSTRING = "substring";
    public static final String LCASE = "lcase";
    public static final String UCASE = "ucase";
    public static final String LENGTH = "length";
    public static final String LOCATE = "locate";
    public static final String ABS = "abs";
    public static final String SQRT = "sqrt";
    public static final String COUNT = "count";
    public static final String MOD = "mod";
    public static JDBCFunctionMappingMetaData COUNT_FUNC;
    public static JDBCFunctionMappingMetaData MAX_FUNC;
    public static JDBCFunctionMappingMetaData MIN_FUNC;
    public static JDBCFunctionMappingMetaData AVG_FUNC;
    public static JDBCFunctionMappingMetaData SUM_FUNC;
    private String name;
    private final HashMap<String, JDBCMappingMetaData> mappings = new HashMap();
    private final HashMap<String, JDBCFunctionMappingMetaData> functionMappings = new HashMap();
    private String aliasHeaderPrefix;
    private String aliasHeaderSuffix;
    private int aliasMaxLength;
    private boolean subquerySupported;
    private String trueMapping;
    private String falseMapping;
    private int maxKeysInDelete;
    private JDBCFunctionMappingMetaData rowLocking = null;
    private JDBCFunctionMappingMetaData fkConstraint = null;
    private JDBCFunctionMappingMetaData pkConstraint = null;
    private JDBCFunctionMappingMetaData autoIncrement = null;
    private JDBCFunctionMappingMetaData addColumn = null;
    private JDBCFunctionMappingMetaData dropColumn = null;
    private JDBCFunctionMappingMetaData alterColumn = null;

    public JDBCTypeMappingMetaData() {
        this.addDefaultFunctionMapping();
    }

    public String getName() {
        return this.name;
    }

    public String getAliasHeaderPrefix() {
        return this.aliasHeaderPrefix;
    }

    public String getAliasHeaderSuffix() {
        return this.aliasHeaderSuffix;
    }

    public int getAliasMaxLength() {
        return this.aliasMaxLength;
    }

    public boolean isSubquerySupported() {
        return this.subquerySupported;
    }

    public String getTrueMapping() {
        return this.trueMapping;
    }

    public String getFalseMapping() {
        return this.falseMapping;
    }

    public int getMaxKeysInDelete() {
        return this.maxKeysInDelete;
    }

    public JDBCMappingMetaData getTypeMappingMetaData(Class type) {
        JDBCMappingMetaData mapping;
        String javaType = type.getName();
        for (int i = 0; i < PRIMITIVES.length; ++i) {
            if (!javaType.equals(PRIMITIVES[i])) continue;
            javaType = PRIMITIVE_CLASSES[i];
            break;
        }
        if ((mapping = this.mappings.get(javaType)) == null) {
            mapping = this.mappings.get("java.lang.Object");
        }
        return mapping;
    }

    public JDBCFunctionMappingMetaData getFunctionMapping(String name) {
        JDBCFunctionMappingMetaData funcMapping = this.functionMappings.get(name.toLowerCase());
        if (funcMapping == null) {
            throw CmpMessages.MESSAGES.functionNotDefinedForType(name, this.name);
        }
        return funcMapping;
    }

    public JDBCFunctionMappingMetaData getRowLockingTemplate() {
        return this.rowLocking;
    }

    public JDBCFunctionMappingMetaData getPkConstraintTemplate() {
        return this.pkConstraint;
    }

    public JDBCFunctionMappingMetaData getFkConstraintTemplate() {
        return this.fkConstraint;
    }

    public JDBCFunctionMappingMetaData getAutoIncrementTemplate() {
        return this.autoIncrement;
    }

    public JDBCFunctionMappingMetaData getAddColumnTemplate() {
        return this.addColumn;
    }

    public JDBCFunctionMappingMetaData getDropColumnTemplate() {
        return this.dropColumn;
    }

    public JDBCFunctionMappingMetaData getAlterColumnTemplate() {
        return this.alterColumn;
    }

    public Collection<JDBCMappingMetaData> getMappings() {
        return this.mappings.values();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAddColumnTemplate(JDBCFunctionMappingMetaData addColumn) {
        this.addColumn = addColumn;
    }

    public void setRowLockingTemplate(JDBCFunctionMappingMetaData rowLocking) {
        this.rowLocking = rowLocking;
    }

    public void setPKConstraintTemplate(JDBCFunctionMappingMetaData pkConstraint) {
        this.pkConstraint = pkConstraint;
    }

    public void setFKConstraintTemplate(JDBCFunctionMappingMetaData fkConstraint) {
        this.fkConstraint = fkConstraint;
    }

    public void setAlterColumnTemplate(JDBCFunctionMappingMetaData alterColumn) {
        this.alterColumn = alterColumn;
    }

    public void setAliasHeaderPrefix(String aliasHeaderPrefix) {
        this.aliasHeaderPrefix = aliasHeaderPrefix;
    }

    public void setAliasHeaderSuffix(String aliasHeaderSuffix) {
        this.aliasHeaderSuffix = aliasHeaderSuffix;
    }

    public void setAliasMaxLength(int aliasMaxLength) {
        this.aliasMaxLength = aliasMaxLength;
    }

    public void setAutoIncrementTemplate(JDBCFunctionMappingMetaData autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setDropColumnTemplate(JDBCFunctionMappingMetaData dropColumn) {
        this.dropColumn = dropColumn;
    }

    public void setFalseMapping(String falseMapping) {
        this.falseMapping = falseMapping;
    }

    public void setMaxKeysInDelete(int maxKeys) {
        this.maxKeysInDelete = maxKeys;
    }

    public void setSubQuerySupported(Boolean subquerySupported) {
        this.subquerySupported = subquerySupported;
    }

    public void setTrueMapping(String trueMapping) {
        this.trueMapping = trueMapping;
    }

    private void addDefaultFunctionMapping() {
        JDBCFunctionMappingMetaData function = new JDBCFunctionMappingMetaData(CONCAT, new String[]{"{fn concat(", ", ", ")}"}, new int[]{0, 1});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(SUBSTRING, new String[]{"{fn substring(", ", ", ", ", ")}"}, new int[]{0, 1, 2});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(LCASE, new String[]{"{fn lcase(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(UCASE, new String[]{"{fn ucase(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(LENGTH, new String[]{"{fn length(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(LOCATE, new String[]{"{fn locate(", ", ", ", ", ")}"}, new int[]{0, 1, 2});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(ABS, new String[]{"{fn abs(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(SQRT, new String[]{"{fn sqrt(", ")}"}, new int[]{0});
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
        function = new JDBCFunctionMappingMetaData(MOD, "mod(?1, ?2)");
        this.functionMappings.put(function.getFunctionName().toLowerCase(), function);
    }

    public void addMapping(JDBCMappingMetaData jdbcMappingMetaData) {
        this.mappings.put(jdbcMappingMetaData.getJavaType(), jdbcMappingMetaData);
    }

    public void addFunctionMapping(JDBCFunctionMappingMetaData functionMapping) {
        this.functionMappings.put(functionMapping.getFunctionName().toLowerCase(), functionMapping);
    }

    static {
        try {
            COUNT_FUNC = new JDBCFunctionMappingMetaData(COUNT, "count(?1 ?2)");
            MAX_FUNC = new JDBCFunctionMappingMetaData("max", "max(?1 ?2)");
            MIN_FUNC = new JDBCFunctionMappingMetaData("min", "min(?1 ?2)");
            AVG_FUNC = new JDBCFunctionMappingMetaData("avg", "avg(?1 ?2)");
            SUM_FUNC = new JDBCFunctionMappingMetaData("sum", "sum(?1 ?2)");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

