/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.io.Serializable;
import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.injection.WeldEEInjection;

class WeldManagedReference
implements ManagedReference,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CreationalContext<?> context;
    private final Object instance;
    private final transient WeldEEInjection injectionTarget;
    private final transient Map<Class<?>, WeldEEInjection> interceptorInjections;

    public WeldManagedReference(CreationalContext<?> ctx, Object instance, WeldEEInjection injectionTarget, Map<Class<?>, WeldEEInjection> interceptorInjections) {
        this.context = ctx;
        this.instance = instance;
        this.injectionTarget = injectionTarget;
        this.interceptorInjections = interceptorInjections;
    }

    public void inject() {
        this.injectionTarget.inject(this.instance, this.context);
    }

    public void injectInterceptor(Class<?> interceptorClass, Object instance) {
        WeldEEInjection injection = this.interceptorInjections.get(interceptorClass);
        if (injection == null) {
            throw WeldMessages.MESSAGES.unknownInterceptorClassForCDIInjection(interceptorClass);
        }
        injection.inject(instance, this.context);
    }

    public void release() {
        this.context.release();
    }

    public Object getInstance() {
        return this.instance;
    }

    public CreationalContext<?> getContext() {
        return this.context;
    }

    public WeldEEInjection getInjectionTarget() {
        return this.injectionTarget;
    }
}

