/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.core;

import java.io.File;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryStorage;
import org.jboss.osgi.repository.RepositoryStorageFactory;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.core.FileBasedRepositoryStorage;
import org.jboss.osgi.repository.core.MavenArtifactRepository;
import org.jboss.osgi.repository.spi.AbstractPersistentRepository;
import org.jboss.osgi.repository.spi.AggregatingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class XRepositoryBuilder {
    public static final String ROOT_REPOSITORY = "root-repository";
    private final Set<ServiceRegistration> registrations = new HashSet<ServiceRegistration>();
    private final BundleContext context;

    public static XRepositoryBuilder create(BundleContext context) {
        return new XRepositoryBuilder(context);
    }

    private XRepositoryBuilder(BundleContext context) {
        this.context = context;
    }

    public void addDefaultRepositoryStorage(final File storageDir) {
        RepositoryStorageFactory factory = new RepositoryStorageFactory(){

            public RepositoryStorage create(XRepository repository) {
                return new FileBasedRepositoryStorage(repository, storageDir);
            }
        };
        this.addRepositoryStorage(factory);
    }

    public void addRepositoryStorage(RepositoryStorageFactory factory) {
        this.registrations.add(this.context.registerService(RepositoryStorageFactory.class.getName(), (Object)factory, null));
    }

    public XRepository addDefaultRepositories() {
        this.addRepository(new MavenArtifactRepository());
        ServiceReference sref = this.context.getServiceReference(RepositoryStorageFactory.class.getName());
        if (sref == null) {
            throw RepositoryMessages.MESSAGES.illegalStateCannotObtainRepositoryStorageFactory();
        }
        RepositoryStorageFactory factory = (RepositoryStorageFactory)this.context.getService(sref);
        AbstractPersistentRepository repository = new AbstractPersistentRepository(factory, this.getRepositoryServiceTracker());
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.ranking", new Integer(1000));
        ((Dictionary)props).put("service.description", repository.getName());
        ((Dictionary)props).put(ROOT_REPOSITORY, Boolean.TRUE);
        this.registrations.add(this.context.registerService(XRepository.SERVICE_NAMES, (Object)repository, props));
        return repository;
    }

    public void addRepository(XRepository repository) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", repository.getName());
        this.registrations.add(this.context.registerService(XRepository.SERVICE_NAMES, (Object)repository, props));
    }

    public XRepository getRepositoryServiceTracker() {
        return new RepositoryServiceTracker(this.context);
    }

    public Set<ServiceRegistration> getRegistrations() {
        return Collections.unmodifiableSet(this.registrations);
    }

    public void unregisterServices() {
        for (ServiceRegistration reg : this.getRegistrations()) {
            reg.unregister();
        }
    }

    static class RepositoryServiceTracker
    extends AggregatingRepository {
        public RepositoryServiceTracker(BundleContext context) {
            ServiceTracker tracker = new ServiceTracker(context, XRepository.class.getName(), null){

                public Object addingService(ServiceReference sref) {
                    XRepository repo = (XRepository)super.addingService(sref);
                    if (sref.getProperty(XRepositoryBuilder.ROOT_REPOSITORY) == null) {
                        RepositoryServiceTracker.this.addRepository(repo);
                    }
                    return repo;
                }

                public void removedService(ServiceReference sref, Object service) {
                    XRepository repo = (XRepository)service;
                    if (sref.getProperty(XRepositoryBuilder.ROOT_REPOSITORY) == null) {
                        RepositoryServiceTracker.this.removeRepository(repo);
                    }
                    super.removedService(sref, service);
                }
            };
            tracker.open();
        }
    }
}

