/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.component;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.deployment.component.ComponentInstantiator;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class WebComponentInstantiator
implements ComponentInstantiator {
    private volatile BasicComponent component;
    private final ServiceRegistry serviceRegistry;
    private final ServiceName serviceName;

    public WebComponentInstantiator(DeploymentUnit deploymentUnit, ComponentDescription componentDescription) {
        this.serviceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{componentDescription.getComponentName()}).append(new String[]{"START"});
        this.serviceRegistry = deploymentUnit.getServiceRegistry();
    }

    public ManagedReference getReference() {
        this.setupComponent();
        return new ManagedReference(){
            private final ComponentInstance instance;
            private boolean destroyed;
            {
                this.instance = WebComponentInstantiator.this.component.createInstance();
            }

            public synchronized void release() {
                if (!this.destroyed) {
                    this.instance.destroy();
                    this.destroyed = true;
                }
            }

            public Object getInstance() {
                return this.instance.getInstance();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupComponent() {
        if (this.component == null) {
            WebComponentInstantiator webComponentInstantiator = this;
            synchronized (webComponentInstantiator) {
                if (this.component == null) {
                    this.component = (BasicComponent)this.serviceRegistry.getRequiredService(this.serviceName).getValue();
                }
            }
        }
    }

    @Override
    public Set<ServiceName> getServiceNames() {
        return Collections.singleton(this.serviceName);
    }

    @Override
    public ManagedReference initializeInstance(final Object instance) {
        this.setupComponent();
        return new ManagedReference(){
            private final ComponentInstance componentInstance;
            private boolean destroyed;
            {
                this.componentInstance = WebComponentInstantiator.this.component.createInstance(instance);
            }

            public synchronized void release() {
                if (!this.destroyed) {
                    this.componentInstance.destroy();
                    this.destroyed = true;
                }
            }

            public Object getInstance() {
                return this.componentInstance.getInstance();
            }
        };
    }
}

