/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.attachment;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.core.soap.attachment.MultipartRelatedEncoder;
import org.jboss.ws.core.soap.utils.SOAPElementWriter;

public class MultipartRelatedSwAEncoder
extends MultipartRelatedEncoder {
    public MultipartRelatedSwAEncoder(SOAPMessage soapMessage) throws SOAPException {
        super(soapMessage);
    }

    @Override
    public void encodeMultipartRelatedMessage() throws SOAPException, MessagingException {
        ParameterList p = new ParameterList();
        p.set("type", "text/xml");
        p.set("start", "<rootpart@ws.jboss.org>");
        MimeMultipart multipart = new MimeMultipart("related" + p);
        MimeBodyPart rootPart = new MimeBodyPart();
        SOAPEnvelope soapEnv = this.soapMessage.getSOAPPart().getEnvelope();
        String envStr = SOAPElementWriter.writeElement((SOAPElement)soapEnv, false);
        rootPart.setText(envStr, "UTF-8");
        rootPart.setContentID("<rootpart@ws.jboss.org>");
        rootPart.setHeader("Content-Type", "text/xml; charset=UTF-8");
        rootPart.setHeader("Content-Transfer-Encoding", "8bit");
        multipart.addBodyPart((BodyPart)rootPart);
        this.addAttachmentParts(multipart);
        this.multipart = multipart;
    }
}

