/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.util.ArrayList;
import java.util.List;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public class EndpointConfigMetaData {
    private final EndpointMetaData epMetaData;
    private List<HandlerMetaData> handlers = new ArrayList<HandlerMetaData>();
    private boolean handlersInitialized;

    public EndpointConfigMetaData(EndpointMetaData parent) {
        this.epMetaData = parent;
    }

    void addHandlers(List<HandlerMetaData> configHandlers) {
        for (HandlerMetaData handler : configHandlers) {
            handler.setEndpointMetaData(this.epMetaData);
        }
        this.handlers.addAll(configHandlers);
    }

    void addHandler(HandlerMetaData handler) {
        handler.setEndpointMetaData(this.epMetaData);
        this.handlers.add(handler);
    }

    void clearHandlers() {
        this.handlers.clear();
        this.handlersInitialized = false;
    }

    public List<HandlerMetaData> getHandlerMetaData(UnifiedHandlerMetaData.HandlerType type) {
        ArrayList<HandlerMetaData> typeHandlers = new ArrayList<HandlerMetaData>();
        for (HandlerMetaData hmd : this.handlers) {
            if (hmd.getHandlerType() != type && type != UnifiedHandlerMetaData.HandlerType.ALL) continue;
            typeHandlers.add(hmd);
        }
        return typeHandlers;
    }

    public boolean isHandlersInitialized() {
        return this.handlersInitialized;
    }

    public void setHandlersInitialized(boolean flag) {
        this.handlersInitialized = flag;
    }

    void configHandlerMetaData() {
        List<HandlerMetaData> sepHandlers = this.getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ENDPOINT);
        this.clearHandlers();
        this.addHandlers(sepHandlers);
    }

    public EndpointMetaData getEndpointMetaData() {
        return this.epMetaData;
    }

    void initializeInternal() {
        for (HandlerMetaData handler : this.handlers) {
            handler.eagerInitialize();
        }
    }
}

