/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation;

import java.io.Serializable;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.relation.AbstractOneToOneMapper;
import org.hibernate.envers.entities.mapper.relation.AbstractToOneMapper;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class OneToOnePrimaryKeyJoinColumnMapper
extends AbstractOneToOneMapper {
    public OneToOnePrimaryKeyJoinColumnMapper(String entityName, String referencedEntityName, PropertyData propertyData) {
        super(entityName, referencedEntityName, propertyData);
    }

    @Override
    protected Object queryForReferencedEntity(AuditReaderImplementor versionsReader, AbstractToOneMapper.EntityInfo referencedEntity, Serializable primaryKey, Number revision) {
        if (referencedEntity.isAudited()) {
            return versionsReader.createQuery().forEntitiesAtRevision(referencedEntity.getEntityClass(), referencedEntity.getEntityName(), revision).add(AuditEntity.id().eq(primaryKey)).getSingleResult();
        }
        return this.createNotAuditedEntityReference(versionsReader, referencedEntity.getEntityClass(), referencedEntity.getEntityName(), primaryKey);
    }

    private Object createNotAuditedEntityReference(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Serializable primaryKey) {
        EntityPersister entityPersister = versionsReader.getSessionImplementor().getFactory().getEntityPersister(entityName);
        if (entityPersister.hasProxy()) {
            return versionsReader.getSession().load(entityClass, primaryKey);
        }
        return versionsReader.getSession().get(entityClass, primaryKey);
    }
}

