/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;

public class XsdBinderTerminatingErrorHandler
implements DOMErrorHandler {
    private static XsdBinderTerminatingErrorHandler errorHandler;

    private XsdBinderTerminatingErrorHandler() {
    }

    public static XsdBinderTerminatingErrorHandler newInstance() {
        if (errorHandler == null) {
            errorHandler = new XsdBinderTerminatingErrorHandler();
        }
        return errorHandler;
    }

    @Override
    public boolean handleError(DOMError error) {
        switch (error.getSeverity()) {
            case 2: {
                throw new JBossXBRuntimeException(this.formatMessage(error));
            }
            case 3: {
                throw new JBossXBRuntimeException(this.formatMessage(error));
            }
            case 1: {
                XsdBinder.log.warn((Object)this.formatMessage(error));
            }
        }
        return false;
    }

    String formatMessage(DOMError error) {
        StringBuffer buf = new StringBuffer();
        DOMLocator location = error.getLocation();
        if (location != null) {
            buf.append(location.getLineNumber()).append(':').append(location.getColumnNumber());
        } else {
            buf.append("[location unavailable]");
        }
        buf.append(' ').append(error.getMessage());
        return buf.toString();
    }
}

