/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LazySet<T>
implements Set<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Set<T> delegate = Collections.emptySet();

    private Set<T> createImplementation() {
        if (!(this.delegate instanceof HashSet)) {
            return new HashSet<T>(this.delegate);
        }
        return this.delegate;
    }

    @Override
    public boolean add(T o) {
        if (this.delegate.isEmpty()) {
            this.delegate = Collections.singleton(o);
            return true;
        }
        this.delegate = this.createImplementation();
        return this.delegate.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.delegate = this.createImplementation();
        return this.delegate.addAll(c);
    }

    @Override
    public void clear() {
        this.delegate = Collections.emptySet();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public boolean remove(Object o) {
        this.delegate = this.createImplementation();
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.delegate = this.createImplementation();
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.delegate = this.createImplementation();
        return this.delegate.retainAll(c);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.delegate.toArray(a);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

