/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.util.NullArgumentException;
import org.jboss.util.WeakObject;

public class WeakSet
extends AbstractSet
implements Set {
    protected final ReferenceQueue queue = new ReferenceQueue();
    protected final Set set;

    public WeakSet(Set set) {
        if (set == null) {
            throw new NullArgumentException("set");
        }
        if (set.size() != 0) {
            Object[] elements = set.toArray();
            set.clear();
            for (int i = 0; i < elements.length; ++i) {
                this.add(elements[i]);
            }
        }
        this.set = set;
    }

    public WeakSet() {
        this(new HashSet());
    }

    protected final void maintain() {
        WeakObject weak;
        while ((weak = (WeakObject)this.queue.poll()) != null) {
            this.set.remove(weak);
        }
    }

    @Override
    public int size() {
        this.maintain();
        return this.set.size();
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            Iterator iter;
            Object UNKNOWN;
            Object next;
            {
                this.iter = WeakSet.this.set.iterator();
                this.next = this.UNKNOWN = new Object();
            }

            @Override
            public boolean hasNext() {
                if (this.next != this.UNKNOWN) {
                    return true;
                }
                while (this.iter.hasNext()) {
                    WeakObject weak = (WeakObject)this.iter.next();
                    Object obj = null;
                    if (weak != null) {
                        Object t = weak.get();
                        obj = t;
                        if (t == null) continue;
                    }
                    this.next = obj;
                    return true;
                }
                return false;
            }

            public Object next() {
                if (this.next == this.UNKNOWN && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object obj = this.next;
                this.next = this.UNKNOWN;
                return obj;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public boolean add(Object obj) {
        this.maintain();
        return this.set.add(WeakObject.create(obj, this.queue));
    }

    @Override
    public boolean isEmpty() {
        this.maintain();
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        this.maintain();
        return this.set.contains(WeakObject.create(obj));
    }

    @Override
    public boolean remove(Object obj) {
        this.maintain();
        return this.set.remove(WeakObject.create(obj));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    public Object clone() {
        this.maintain();
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

