/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.taskdefs.Execute;

public class EnvironmentConfiguration
extends AbstractConfiguration {
    private static final String METHOD_NAME = "getenv";
    private static final int VERSION_1_5 = 150;
    private Map environment;

    public EnvironmentConfiguration() {
        if (SystemUtils.isJavaVersionAtLeast((int)150)) {
            this.extractProperties15();
        } else {
            this.extractProperties14();
        }
    }

    @Override
    protected void addPropertyDirect(String key, Object value) {
        throw new UnsupportedOperationException("Configuration is read-only!");
    }

    @Override
    public boolean containsKey(String key) {
        return this.environment.containsKey(key);
    }

    @Override
    public Iterator getKeys() {
        return this.environment.keySet().iterator();
    }

    @Override
    public Object getProperty(String key) {
        return this.environment.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.environment.isEmpty();
    }

    @Override
    public void clearProperty(String key) {
        throw new UnsupportedOperationException("Configuration is read-only!");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Configuration is read-only!");
    }

    void extractProperties14() {
        this.extractPropertiesFromCollection(Execute.getProcEnvironment());
    }

    void extractPropertiesFromCollection(Collection env) {
        this.environment = new HashMap();
        for (String entry : env) {
            int pos = entry.indexOf(61);
            if (pos == -1) {
                this.getLogger().warn((Object)("Ignoring: " + entry));
                continue;
            }
            this.environment.put(entry.substring(0, pos), entry.substring(pos + 1));
        }
    }

    void extractProperties15() {
        try {
            Method method = System.class.getMethod(METHOD_NAME, null);
            this.environment = (Map)method.invoke(null, null);
        }
        catch (Exception ex) {
            throw new ConfigurationRuntimeException("Error when accessing environment properties", ex);
        }
    }
}

