/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ConfigurationNodeVisitor;

public class DefaultConfigurationNode
implements ConfigurationNode,
Cloneable {
    private SubNodes children;
    private SubNodes attributes;
    private ConfigurationNode parent;
    private Object value;
    private Object reference;
    private String name;
    private boolean attribute;

    public DefaultConfigurationNode() {
        this(null);
    }

    public DefaultConfigurationNode(String name) {
        this(name, null);
    }

    public DefaultConfigurationNode(String name, Object value) {
        this.setName(name);
        this.setValue(value);
        this.initSubNodes();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.checkState();
        this.name = name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object val) {
        this.value = val;
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    @Override
    public void setReference(Object reference) {
        this.reference = reference;
    }

    @Override
    public ConfigurationNode getParentNode() {
        return this.parent;
    }

    @Override
    public void setParentNode(ConfigurationNode parent) {
        this.parent = parent;
    }

    @Override
    public void addChild(ConfigurationNode child) {
        this.children.addNode(child);
        child.setAttribute(false);
        child.setParentNode(this);
    }

    @Override
    public List getChildren() {
        return this.children.getSubNodes();
    }

    @Override
    public int getChildrenCount() {
        return this.children.getSubNodes().size();
    }

    @Override
    public List getChildren(String name) {
        return this.children.getSubNodes(name);
    }

    @Override
    public int getChildrenCount(String name) {
        return this.children.getSubNodes(name).size();
    }

    @Override
    public ConfigurationNode getChild(int index) {
        return this.children.getNode(index);
    }

    @Override
    public boolean removeChild(ConfigurationNode child) {
        return this.children.removeNode(child);
    }

    @Override
    public boolean removeChild(String childName) {
        return this.children.removeNodes(childName);
    }

    @Override
    public void removeChildren() {
        this.children.clear();
    }

    @Override
    public boolean isAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(boolean f) {
        this.checkState();
        this.attribute = f;
    }

    @Override
    public void addAttribute(ConfigurationNode attr) {
        this.attributes.addNode(attr);
        attr.setAttribute(true);
        attr.setParentNode(this);
    }

    @Override
    public List getAttributes() {
        return this.attributes.getSubNodes();
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.getSubNodes().size();
    }

    @Override
    public List getAttributes(String name) {
        return this.attributes.getSubNodes(name);
    }

    @Override
    public int getAttributeCount(String name) {
        return this.getAttributes(name).size();
    }

    @Override
    public boolean removeAttribute(ConfigurationNode node) {
        return this.attributes.removeNode(node);
    }

    @Override
    public boolean removeAttribute(String name) {
        return this.attributes.removeNodes(name);
    }

    @Override
    public ConfigurationNode getAttribute(int index) {
        return this.attributes.getNode(index);
    }

    @Override
    public void removeAttributes() {
        this.attributes.clear();
    }

    @Override
    public boolean isDefined() {
        return this.getValue() != null || this.getChildrenCount() > 0 || this.getAttributeCount() > 0;
    }

    @Override
    public void visit(ConfigurationNodeVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor must not be null!");
        }
        if (!visitor.terminate()) {
            visitor.visitBeforeChildren(this);
            this.children.visit(visitor);
            this.attributes.visit(visitor);
            visitor.visitAfterChildren(this);
        }
    }

    @Override
    public Object clone() {
        try {
            DefaultConfigurationNode copy = (DefaultConfigurationNode)super.clone();
            copy.initSubNodes();
            return copy;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException("Cannot clone " + this.getClass());
        }
    }

    protected void checkState() {
        if (this.getParentNode() != null) {
            throw new IllegalStateException("Node cannot be modified when added to a parent!");
        }
    }

    protected SubNodes createSubNodes(boolean attributes) {
        return new SubNodes();
    }

    protected void removeReference() {
    }

    private void initSubNodes() {
        this.children = this.createSubNodes(false);
        this.attributes = this.createSubNodes(true);
    }

    protected static class SubNodes {
        private List nodes;
        private Map namedNodes;

        protected SubNodes() {
        }

        public void addNode(ConfigurationNode node) {
            if (node == null || node.getName() == null) {
                throw new IllegalArgumentException("Node to add must have a defined name!");
            }
            node.setParentNode(null);
            if (this.nodes == null) {
                this.nodes = new ArrayList();
                this.namedNodes = new HashMap();
            }
            this.nodes.add(node);
            LinkedList<ConfigurationNode> lst = (LinkedList<ConfigurationNode>)this.namedNodes.get(node.getName());
            if (lst == null) {
                lst = new LinkedList<ConfigurationNode>();
                this.namedNodes.put(node.getName(), lst);
            }
            lst.add(node);
        }

        public boolean removeNode(ConfigurationNode node) {
            if (this.nodes != null && node != null && this.nodes.contains(node)) {
                this.detachNode(node);
                this.nodes.remove(node);
                List lst = (List)this.namedNodes.get(node.getName());
                if (lst != null) {
                    lst.remove(node);
                    if (lst.isEmpty()) {
                        this.namedNodes.remove(node.getName());
                    }
                }
                return true;
            }
            return false;
        }

        public boolean removeNodes(String name) {
            List lst;
            if (this.nodes != null && name != null && (lst = (List)this.namedNodes.remove(name)) != null) {
                this.detachNodes(lst);
                this.nodes.removeAll(lst);
                return true;
            }
            return false;
        }

        public void clear() {
            if (this.nodes != null) {
                this.detachNodes(this.nodes);
                this.nodes = null;
                this.namedNodes = null;
            }
        }

        public ConfigurationNode getNode(int index) {
            if (this.nodes == null) {
                throw new IndexOutOfBoundsException("No sub nodes available!");
            }
            return (ConfigurationNode)this.nodes.get(index);
        }

        public List getSubNodes() {
            return this.nodes == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.nodes);
        }

        public List getSubNodes(String name) {
            if (name == null) {
                return this.getSubNodes();
            }
            List result = this.nodes == null ? null : (List)this.namedNodes.get(name);
            return result == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(result);
        }

        public void visit(ConfigurationNodeVisitor visitor) {
            if (this.nodes != null) {
                Iterator it = this.nodes.iterator();
                while (it.hasNext() && !visitor.terminate()) {
                    ((ConfigurationNode)it.next()).visit(visitor);
                }
            }
        }

        protected void detachNode(ConfigurationNode subNode) {
            subNode.setParentNode(null);
            if (subNode instanceof DefaultConfigurationNode) {
                ((DefaultConfigurationNode)subNode).removeReference();
            }
        }

        protected void detachNodes(Collection subNodes) {
            Iterator it = subNodes.iterator();
            while (it.hasNext()) {
                this.detachNode((ConfigurationNode)it.next());
            }
        }
    }
}

