/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.publish;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.deployers.EndpointServiceDeploymentAspect;
import org.jboss.as.webservices.deployers.deployment.DeploymentAspectsProvider;
import org.jboss.as.webservices.deployers.deployment.WSDeploymentBuilder;
import org.jboss.as.webservices.publish.SecurityActions;
import org.jboss.as.webservices.publish.WSEndpointDeploymentUnit;
import org.jboss.as.webservices.service.ServerConfigService;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.ws.common.deployment.DeploymentAspectManagerImpl;
import org.jboss.ws.common.invocation.InvocationHandlerJAXWS;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointState;
import org.jboss.wsf.spi.deployment.WSFServlet;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.publish.Context;
import org.jboss.wsf.spi.publish.EndpointPublisher;

public final class EndpointPublisherImpl
implements EndpointPublisher {
    private Host host;
    private boolean runningInService = false;
    private static List<DeploymentAspect> depAspects = null;

    public EndpointPublisherImpl(Host host) {
        this.host = host;
    }

    public EndpointPublisherImpl(Host host, boolean runningInService) {
        this(host);
        this.runningInService = runningInService;
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap) throws Exception {
        return this.publish(EndpointPublisherImpl.getBaseTarget(), context, loader, urlPatternToClassNameMap, null, null, null);
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, WebservicesMetaData metadata) throws Exception {
        return this.publish(EndpointPublisherImpl.getBaseTarget(), context, loader, urlPatternToClassNameMap, null, metadata, null);
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, WebservicesMetaData metadata, JBossWebservicesMetaData jbwsMetadata) throws Exception {
        return this.publish(EndpointPublisherImpl.getBaseTarget(), context, loader, urlPatternToClassNameMap, null, metadata, jbwsMetadata);
    }

    public Context publish(ServiceTarget target, String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, JBossWebMetaData jbwmd, WebservicesMetaData metadata, JBossWebservicesMetaData jbwsMetadata) throws Exception {
        WSEndpointDeploymentUnit unit = new WSEndpointDeploymentUnit(loader, context, urlPatternToClassNameMap, jbwmd, metadata, jbwsMetadata);
        return new Context(context, this.publish(target, unit));
    }

    private static ServiceTarget getBaseTarget() {
        return WSServices.getContainerRegistry().getService(WSServices.CONFIG_SERVICE).getServiceContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Endpoint> publish(ServiceTarget target, WSEndpointDeploymentUnit unit) throws Exception {
        List<DeploymentAspect> aspects = this.getDeploymentAspects();
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        Deployment dep = null;
        try {
            SecurityActions.setContextClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            WSDeploymentBuilder.getInstance().build(unit);
            dep = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
            dep.addAttachment(ServiceTarget.class, (Object)target);
            DeploymentAspectManagerImpl dam = new DeploymentAspectManagerImpl();
            dam.setDeploymentAspects(aspects);
            dam.deploy(dep);
            Iterator i$ = dep.getService().getEndpoints().iterator();
            while (i$.hasNext()) {
                Endpoint ep;
                Endpoint endpoint = ep = (Endpoint)i$.next();
                synchronized (endpoint) {
                    ep.setState(EndpointState.STOPPED);
                    ep.setInvocationHandler((InvocationHandler)new InvocationHandlerJAXWS());
                    ep.setState(EndpointState.STARTED);
                }
            }
        }
        finally {
            if (dep != null) {
                dep.removeAttachment(ServiceTarget.class);
            }
            SecurityActions.setContextClassLoader(origClassLoader);
        }
        Deployment deployment = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
        deployment.addAttachment(StandardContext.class, (Object)EndpointPublisherImpl.startWebApp(this.host, unit));
        return deployment.getService().getEndpoints();
    }

    private static StandardContext startWebApp(Host host, WSEndpointDeploymentUnit unit) throws Exception {
        StandardContext context = new StandardContext();
        try {
            JBossWebMetaData jbwebMD = (JBossWebMetaData)unit.getAttachment(WSAttachmentKeys.JBOSSWEB_METADATA_KEY);
            context.setPath(jbwebMD.getContextRoot());
            context.addLifecycleListener((LifecycleListener)new ContextConfig());
            ServerConfigService config = (ServerConfigService)unit.getServiceRegistry().getService(WSServices.CONFIG_SERVICE).getService();
            File docBase = new File(config.getValue().getServerTempDir(), jbwebMD.getContextRoot());
            if (!docBase.exists()) {
                docBase.mkdirs();
            }
            context.setDocBase(docBase.getPath());
            WebCtxLoader loader = new WebCtxLoader((ClassLoader)unit.getAttachment(WSAttachmentKeys.CLASSLOADER_KEY));
            loader.setContainer((Container)host);
            context.setLoader((Loader)loader);
            context.setInstanceManager((InstanceManager)new LocalInstanceManager());
            EndpointPublisherImpl.addServlets(jbwebMD, context);
            host.addChild((Container)context);
            context.create();
        }
        catch (Exception e) {
            throw WSMessages.MESSAGES.createContextPhaseFailed(e);
        }
        try {
            context.start();
        }
        catch (LifecycleException e) {
            throw WSMessages.MESSAGES.startContextPhaseFailed(e);
        }
        return context;
    }

    private static void addServlets(JBossWebMetaData jbwebMD, StandardContext context) {
        for (JBossServletMetaData smd : jbwebMD.getServlets()) {
            String sc = smd.getServletClass();
            if (!sc.equals(WSFServlet.class.getName())) continue;
            String servletName = smd.getServletName();
            List params = smd.getInitParam();
            List urlPatterns = null;
            for (ServletMappingMetaData smmd : jbwebMD.getServletMappings()) {
                if (!smmd.getServletName().equals(servletName)) continue;
                urlPatterns = smmd.getUrlPatterns();
                break;
            }
            WSFServlet wsfs = new WSFServlet();
            Wrapper wsfsWrapper = context.createWrapper();
            wsfsWrapper.setName(servletName);
            wsfsWrapper.setServlet((Servlet)wsfs);
            wsfsWrapper.setServletClass(WSFServlet.class.getName());
            for (ParamValueMetaData param : params) {
                wsfsWrapper.addInitParameter(param.getParamName(), param.getParamValue());
            }
            context.addChild((Container)wsfsWrapper);
            for (String urlPattern : urlPatterns) {
                context.addServletMapping(urlPattern, servletName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Context context) throws Exception {
        List eps = context.getEndpoints();
        if (eps == null || eps.isEmpty()) {
            return;
        }
        Deployment deployment = ((Endpoint)eps.get(0)).getService().getDeployment();
        List<DeploymentAspect> aspects = this.getDeploymentAspects();
        try {
            EndpointPublisherImpl.stopWebApp((StandardContext)deployment.getAttachment(StandardContext.class));
        }
        finally {
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
                DeploymentAspectManagerImpl dam = new DeploymentAspectManagerImpl();
                dam.setDeploymentAspects(aspects);
                dam.undeploy(deployment);
            }
            finally {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    private static void stopWebApp(StandardContext context) throws Exception {
        try {
            Container container = context.getParent();
            container.removeChild((Container)context);
            context.stop();
        }
        catch (LifecycleException e) {
            throw WSMessages.MESSAGES.stopContextPhaseFailed(e);
        }
        try {
            context.destroy();
        }
        catch (Exception e) {
            throw WSMessages.MESSAGES.destroyContextPhaseFailed(e);
        }
    }

    private List<DeploymentAspect> getDeploymentAspects() {
        return this.runningInService ? DeploymentAspectsProvider.getSortedDeploymentAspects() : EndpointPublisherImpl.getPublisherDeploymentAspects();
    }

    private static synchronized List<DeploymentAspect> getPublisherDeploymentAspects() {
        if (depAspects == null) {
            depAspects = new LinkedList<DeploymentAspect>();
            List<DeploymentAspect> serverAspects = DeploymentAspectsProvider.getSortedDeploymentAspects();
            for (DeploymentAspect aspect : serverAspects) {
                if (aspect instanceof EndpointServiceDeploymentAspect) {
                    EndpointServiceDeploymentAspect a = (EndpointServiceDeploymentAspect)aspect;
                    EndpointServiceDeploymentAspect clone = (EndpointServiceDeploymentAspect)a.clone();
                    clone.setStopServices(true);
                    depAspects.add((DeploymentAspect)clone);
                    continue;
                }
                depAspects.add(aspect);
            }
        }
        return depAspects;
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        LocalInstanceManager() {
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(className).newInstance();
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

