/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.ProcessingException;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.DateAttribute;
import org.jboss.security.xacml.sunxacml.attr.DateTimeAttribute;
import org.w3c.dom.Node;

public class TimeAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#time";
    private static URI identifierURI = URI.create("http://www.w3.org/2001/XMLSchema#time");
    public static final int TZ_UNSPECIFIED = -1000000;
    private long timeGMT;
    private int nanoseconds;
    private int timeZone;
    private int defaultedTimeZone;
    private String encodedValue = null;

    public TimeAttribute() {
        this(new Date());
    }

    public TimeAttribute(Date time) {
        super(identifierURI);
        int currOffset = DateTimeAttribute.getDefaultTZOffset(time);
        this.init(time, 0, currOffset, currOffset);
    }

    public TimeAttribute(Date time, int nanoseconds, int timeZone, int defaultedTimeZone) {
        super(identifierURI);
        if (timeZone == -1000000 && defaultedTimeZone == -1000000) {
            throw new ProcessingException("default timezone must be specifiedwhen a timezone is provided");
        }
        this.init(time, nanoseconds, timeZone, defaultedTimeZone);
    }

    private void init(Date date, int nanoseconds, int timeZone, int defaultedTimeZone) {
        Date tmpDate = (Date)date.clone();
        this.nanoseconds = DateTimeAttribute.combineNanos(tmpDate, nanoseconds);
        this.timeGMT = tmpDate.getTime();
        this.timeZone = timeZone;
        this.defaultedTimeZone = defaultedTimeZone;
        if (this.timeGMT >= 86400000L || this.timeGMT < 0L) {
            long div = this.timeGMT / 86400000L;
            this.timeGMT %= 86400000L;
            if (div == 1L) {
                this.timeGMT += 86400000L;
            }
            if (this.timeGMT < 0L) {
                this.timeGMT += 86400000L;
            }
        }
    }

    public static TimeAttribute getInstance(Node root) throws ParsingException, NumberFormatException, ParseException {
        return TimeAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static TimeAttribute getInstance(String value) throws ParsingException, NumberFormatException, ParseException {
        value = "1970-01-01T" + value;
        DateTimeAttribute dateTime = DateTimeAttribute.getInstance(value);
        Date dateValue = dateTime.getValue();
        int defaultedTimeZone = dateTime.getDefaultedTimeZone();
        if (dateTime.getTimeZone() == -1000000) {
            int newDefTimeZone = DateTimeAttribute.getDefaultTZOffset(new Date());
            dateValue = new Date(dateValue.getTime() - (long)((newDefTimeZone - defaultedTimeZone) * 60000));
            defaultedTimeZone = newDefTimeZone;
        }
        return new TimeAttribute(dateValue, dateTime.getNanoseconds(), dateTime.getTimeZone(), defaultedTimeZone);
    }

    @Override
    public Date getValue() {
        return new Date(this.timeGMT);
    }

    public long getMilliseconds() {
        return this.timeGMT;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public int getDefaultedTimeZone() {
        return this.defaultedTimeZone;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimeAttribute)) {
            return false;
        }
        TimeAttribute other = (TimeAttribute)o;
        return this.timeGMT == other.timeGMT && this.nanoseconds == other.nanoseconds;
    }

    public int hashCode() {
        int hashCode = (int)(this.timeGMT ^ this.timeGMT >>> 32);
        hashCode = 31 * hashCode + this.nanoseconds;
        return hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TimeAttribute: [\n");
        long secsGMT = this.timeGMT / 1000L;
        long minsGMT = secsGMT / 60L;
        long hoursGMT = minsGMT / 60L;
        String hoursStr = hoursGMT < 10L ? "0" + hoursGMT : "" + hoursGMT;
        String minsStr = minsGMT < 10L ? "0" + minsGMT : "" + (minsGMT %= 60L);
        String secsStr = secsGMT < 10L ? "0" + secsGMT : "" + (secsGMT %= 60L);
        sb.append("  Time GMT: " + hoursStr + ":" + minsStr + ":" + secsStr);
        sb.append("  Nanoseconds: " + this.nanoseconds);
        sb.append("  TimeZone: " + this.timeZone);
        sb.append("  Defaulted TimeZone: " + this.defaultedTimeZone);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        StringBuffer buf = new StringBuffer(27);
        int millis = (int)this.timeGMT;
        millis = this.timeZone == -1000000 ? (millis += this.defaultedTimeZone * 60000) : (millis += this.timeZone * 60000);
        if (millis < 0) {
            millis = (int)((long)millis + 86400000L);
        } else if ((long)millis >= 86400000L) {
            millis = (int)((long)millis - 86400000L);
        }
        int hour = millis / 3600000;
        buf.append(DateAttribute.zeroPadInt(hour, 2));
        buf.append(':');
        int minute = (millis %= 3600000) / 60000;
        buf.append(DateAttribute.zeroPadInt(minute, 2));
        buf.append(':');
        int second = (millis %= 60000) / 1000;
        buf.append(DateAttribute.zeroPadInt(second, 2));
        if (this.nanoseconds != 0) {
            buf.append('.');
            buf.append(DateAttribute.zeroPadInt(this.nanoseconds, 9));
        }
        if (this.timeZone != -1000000) {
            int tzNoSign = this.timeZone;
            if (this.timeZone < 0) {
                tzNoSign = -tzNoSign;
                buf.append('-');
            } else {
                buf.append('+');
            }
            int tzHours = tzNoSign / 60;
            buf.append(DateAttribute.zeroPadInt(tzHours, 2));
            buf.append(':');
            int tzMinutes = tzNoSign % 60;
            buf.append(DateAttribute.zeroPadInt(tzMinutes, 2));
        }
        this.encodedValue = buf.toString();
        return this.encodedValue;
    }
}

