/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.pojo.PojoMessages;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ValueConfig;

public class MapConfig
extends ValueConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String keyType;
    protected String valueType;
    private Map<ValueConfig, ValueConfig> map = new HashMap<ValueConfig, ValueConfig>();
    private Class<?> mapType;
    private Class<?> keyClass;
    private Class<?> valueClass;

    protected Map<Object, Object> createInstance() {
        try {
            if (this.mapType != null) {
                return (Map)this.mapType.newInstance();
            }
            return new HashMap<Object, Object>();
        }
        catch (Exception e) {
            throw PojoMessages.MESSAGES.cannotInstantiateMap(e);
        }
    }

    @Override
    public void visit(ConfigVisitor visitor) {
        this.mapType = MapConfig.getType(visitor, this.getType());
        this.keyClass = MapConfig.getType(visitor, this.keyType);
        this.valueClass = MapConfig.getType(visitor, this.valueType);
        super.visit(visitor);
    }

    @Override
    protected void addChildren(ConfigVisitor visitor, List<ConfigVisitorNode> nodes) {
        nodes.addAll(this.map.keySet());
        nodes.addAll(this.map.values());
    }

    @Override
    protected Object getPtValue(ParameterizedType type) {
        Type vt;
        Type kt = this.keyClass;
        if (kt == null && type != null) {
            kt = MapConfig.getComponentType(type, 0);
        }
        if ((vt = this.valueClass) == null && type != null) {
            vt = MapConfig.getComponentType(type, 1);
        }
        Map<Object, Object> result = this.createInstance();
        for (Map.Entry<ValueConfig, ValueConfig> entry : this.map.entrySet()) {
            result.put(entry.getKey().getValue(kt), entry.getValue().getValue(vt));
        }
        return result;
    }

    @Override
    protected Object getClassValue(Class<?> type) {
        Map<Object, Object> result = this.createInstance();
        for (Map.Entry<ValueConfig, ValueConfig> entry : this.map.entrySet()) {
            result.put(entry.getKey().getValue(this.keyClass), entry.getValue().getValue(this.valueClass));
        }
        return result;
    }

    public void put(ValueConfig key, ValueConfig value) {
        this.map.put(key, value);
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }
}

