/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.naming;

import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.BundleContext;

final class BundleContextBindingService {
    private static final String BUNDLE_CONTEXT_BINDING_NAME = "java:jboss/osgi/BundleContext";

    BundleContextBindingService() {
    }

    static ServiceController<?> addService(ServiceTarget serviceTarget) {
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)BUNDLE_CONTEXT_BINDING_NAME);
        BinderService binderService = new BinderService(bindInfo.getBindName()){

            public synchronized void start(StartContext context) throws StartException {
                super.start(context);
                ServiceController controller = context.getController();
                controller.setMode(ServiceController.Mode.ACTIVE);
            }
        };
        ServiceBuilder builder = serviceTarget.addService(BundleContextBindingService.getBinderServiceName(), (Service)binderService);
        builder.addDependency(Services.FRAMEWORK_ACTIVE, BundleContext.class, (Injector)new ManagedReferenceInjector(binderService.getManagedObjectInjector()));
        builder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        OSGiLogger.LOGGER.infoBoundSystemContext(BundleContextBindingService.BUNDLE_CONTEXT_BINDING_NAME);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        OSGiLogger.LOGGER.infoUnboundSystemContext(BundleContextBindingService.BUNDLE_CONTEXT_BINDING_NAME);
                    }
                }
            }
        });
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    public static ServiceName getBinderServiceName() {
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)BUNDLE_CONTEXT_BINDING_NAME);
        return bindInfo.getBinderServiceName();
    }
}

